require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative '../helpers/entry_form'

class MyMedical < EntryForm
  include DriverUtility

  PLAN_YOUR_APPOINTMENT_BUTTON = "button.plan-your-appointment"
  DIAGNOSIS_BUTTON = "button.diagnoses"
  SURGERIES_BUTTON = "button.surgeries"
  HOSPITALIZATIONS_BUTTON = "button.hospitalizations"
  PREGNANCY_HISTORY_BUTTON = "button.pregnancy-history"
  FAMILY_HISTORY_BUTTON = "button.family-history"
  SYMPTOM_BUTTON = "button.symptom-diary"
  ALLERGIES_BUTTON = "button.allergies"
  MEDICATIONS_BUTTON = "button.medications"

  
  LEARN_BUTTON = "i.icon-gradcap"
  BACK_BTN = "i.icon-nav-left-arrow"
  I_BTN = "i.icon-info"

  DIAGNOSIS_LABEL = "diagnosisLabel"
  RELATIVE_NAME_LABEL = "nameLabel"
  RELATIVE_LABEL = "relativeLabel"
  RELATIONSHIP_TYPE_LABEL = "relationshipTypeLabel"

  FIRST_NAME = "firstName"
  LAST_NAME = "lastName"
  RELATIVE = "Relative"
  RELATIONSHIP_TYPE = "relationshipType"

  START_DATE = "input[id='startDate']"
  END_DATE = "input[id='endDate']"


  def initialize(driver)
    @driver = driver
  end
      
  def getNthMyMedicalFeatureName(number)
    return getTextForElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") ")
  end


  ######################  Items Visibilities ##################################
  def isPlanYourAppointmentVisible()
    return isElementVisible(:css, PLAN_YOUR_APPOINTMENT_BUTTON)
  end

  def isDiagnosesButtonVisible()
    return isElementVisible(:css, DIAGNOSIS_BUTTON)
  end

  def isSurgeriesIconVisible()
    return isElementVisible(:css, SURGERIES_BUTTON)
  end

  def isHospitalizationsIconVisible()
    return isElementVisible(:css, HOSPITALIZATIONS_BUTTON)
  end

  def isPregnancyHistoryIconVisible()
    return isElementVisible(:css, PREGNANCY_HISTORY_BUTTON)
  end

  def isFamilyHistoryIconVisible()
    return isElementVisible(:css, FAMILY_HISTORY_BUTTON)
  end

  def isSymptomIconVisible()
    return isElementVisible(:css, SYMPTOM_BUTTON)
  end

  def isLearnIconVisible()
    return isElementVisible(:css, LEARN_BUTTON)
  end
  
  def isIBtnVisible()
    return isElementVisible(:css, I_BTN)
  end

  def isNthIconDisplayedLeftOfItem(number)
   element = getElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") span div div :nth-child(1)")
   return ( element.tag_name == "i" ? true: false)
  end


######################  Page Actions ##################################
  def clickPlanYourAppointment()
    waitForPageToFinishLoading
    click(:css, PLAN_YOUR_APPOINTMENT_BUTTON)
  end

  def clickDiagnoses()
    waitForPageToFinishLoading
    click(:css, DIAGNOSIS_BUTTON)
  end

  def clickSurgeries()
    waitForPageToFinishLoading
    click(:css, SURGERIES_BUTTON)
  end
  
  def clickHospitalizations()
    waitForPageToFinishLoading
    click(:css, HOSPITALIZATIONS_BUTTON)
  end
  
  def clickPregnancyHistory()
    click(:css, PREGNANCY_HISTORY_BUTTON)
  end
  
  def clickFamilyHistory()
    waitForPageToFinishLoading
    click(:css, FAMILY_HISTORY_BUTTON)
  end

  def clickSymptom()
    waitForPageToFinishLoading
    click(:css, SYMPTOM_BUTTON)
  end

  def clickLearn()
    click(:css, LEARN_BUTTON)
  end

  def clickBackButton()
    click(:css,  BACK_BTN)
  end

  def clickIButton()
    click(:css, I_BTN)
  end

  def clickAllergies()
    waitForPageToFinishLoading
    click(:css, ALLERGIES_BUTTON)
  end

  def clickMedications()
    waitForPageToFinishLoading
    click(:css, MEDICATIONS_BUTTON)
  end

  def setStartDate(date)
    @driver.find_element(:css, START_DATE).clear
    @driver.find_element(:css, START_DATE).send_keys(date)
  end

  def setEndDate(date)
    @driver.find_element(:css, END_DATE).clear
    @driver.find_element(:css, END_DATE).send_keys(date)
  end

  
########### PAGE HELPERS ############################  
  
  ######  Common

  def isSaveChangesDisabled()
    element = getElement(:css, 'button[title="Save Changes"]')
    disabled = element.attribute("disabled")

    if(disabled != nil and disabled == "true")
      return true
    else
      return false
    end

  end

  def clickSaveChangesBtn()
    click(:css,  'button[title="Save Changes"]')
  end
  
  ########  Arrows helpers
  def isRightArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-static"))
      return true
    else
      return false
    end

  end

  def isDownArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-active"))
      return true
    else
      return false
    end

  end

  ########  Accordion helpers
  def getNthAccordionName(number)
    return getTextForElement(:css, "form[name='assessmentForm'] div div:nth-child(" + number.to_s + ") h4 a")
  end


  def clickAccordionByHeading(heading)
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-static')
  end

  def collapseAccordionByHeading(heading)
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-active')
  end

  def getCollapsedAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Expand\n")
    return label[1]

  end

  def isAccordionCollapsed(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    if(labelText.include?("Expand"))
      return true
    else
      false
    end
  end


  def getAccordionAltText(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')
  end

  def getAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Collapse\n")
    return label[1]
  end

  def getAccordionInfoTextByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div p.ng-binding ')
  end


  ######  End of Common

  #### Hospitalizations 
  
  ########### End of Hospitalizations

  ###############################  Family History ##################################

  def setDiagnosis(diagStr, cssPath)
    #cssPath could be e.g. "input[name='date']"
    sleep 1
    @driver.find_element(:css, cssPath).clear
    @driver.find_element(:css, cssPath).send_keys(diagStr)
    sleep 2
  end

  def getTotalDiagnosisEntries()
    return getElements(:css, "multi-diagnosis input-text").length
    sleep 1
  end

  def clickAddDiagnosis()
    waitForPageToFinishLoading
    click(:css, ".btn.btn-default.diagnoses")
  end

  def selectCurrentStatusofRelative(type)
    click(:css, "select[name='outcome'] option[value='" + type + "']")
    sleep 0.5
  end

  ###############################  End of Family History ##################################
end