require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Modal_popup
  include DriverUtility

  ABOUT_BTN = "about"
  LOGOUT_BTN = "logout"
  LAUNCHPAD_BTN = "launchpad"
  TOP_MODAL = ".modal:last-of-type "
  MODAL_WINDOW = ".modal-dialog"
  HEADING = ".modal-header h3"
  MODAL_FIRST_ACTION = ".modal-footer button:nth-of-type(1)"
  MODAL_SECOND_ACTION = ".modal-footer button:nth-of-type(2)"

  def initialize(driver)
    @driver = driver
  end

  def isModalVisible()
    return isElementPresentAndVisible(:css, MODAL_WINDOW)
  end

  def getConfirmationHeading()
    #puts "getConfirmationHeading=" + getTextForElement(:css, "div.modal-header h3")
    return getTextForElement(:css, ".modal-header h3")
  end

  def getTopLayerModalConfirmationHeading() #This function suits for two modal overlay
    return getTextForElement(:css, ".modal-header h3.ng-binding")
  end

  def getInstructionalText()
    return getTextForElement(:css, "div.modal-body p:nth-of-type(1)")
  end

  def getConfirmationMessage()
    return getTextForElement(:css, "div.modal-body")
  end

  def getAllTimeZone()
    return getTextForElement(:css, "select[name='timeZone']")
  end

  def getNthConfirmationMessage(number)
    return getTextForElement(:css, "div.modal-body p:nth-of-type(" + number.to_s + ")")
  end

  def clickYesButton
    click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(2)")
  end

  def clickNoButton
    click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(1)")
  end

  def clickReturnButton
    waitForPageToFinishLoading
    clickNoButton()
  end

  def clickContinueButton
    clickYesButton()
  end

  def clickSaveButton
    #click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(1)")
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickSaveButtonByFunctionName(functionName)
    click(:css, "button[data-ng-click='" + functionName + "']")
  end

  def clickCancelButtonByFunctionName(functionName)
    click(:css, "button[data-ng-click='" + functionName + "']")
  end

  def clickCancelButton
    click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(2)")
  end

  def clickOKFromSaveDraftConfirmation()
    clickNoButton()
  end

  def clickOKButton()
    clickYesButton()
  end

  def clickOKFromInfoModal()
    click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(1)")
  end

####################################################################################################################
############## THE LINK IS SHOWING AS "User Guide / General Feedback to the VA" IN THE APP  ########################
############## ACCORDING TO REGRESSION TEST CASES THE LINK SHOULD SHOW AS "General Feedback to the VA" #############
#################################### SHOULD THE BELOW CODE STAY UPDATED? ###########################################
####################################################################################################################

  def clickUserGuideLink()
    click(:link_text, "User Guide / General Feedback to the VA")
  end

####################################################################################################################
############## THE LINK IS SHOWING AS "User Guide / General Feedback to the VA" IN THE APP  ########################
############## ACCORDING TO REGRESSION TEST CASES THE LINK SHOULD SHOW AS "General Feedback to the VA" #############
#################################### SHOULD THE ABOVE CODE STAY UPDATED? ###########################################
####################################################################################################################

  def clickOKFromHelp()
    click(:css, TOP_MODAL + ".modal-footer button:nth-of-type(1)")
  end

  def isConfirmationPopUpPresent()
    begin
      element = @driver.find_element(:css, "div.modal-header h3")
      return element.displayed?
    rescue Exception=>e
      return false
    end
  end

  def requiredFieldText()
    !45.times{ break if (@driver.find_element(:css, "div > form > span").displayed?); sleep 1 }
    return getTextForElement(:css, "div > form > span")
  end

  def receiveVAHealthMessages()
    !45.times{ break if (@driver.find_element(:css, "div > fieldset > legend").displayed?); sleep 1 }
    return getTextForElement(:css, "div > fieldset > legend")
  end

  def isReceiveNotificationsSelected(yesNo)
    element = getElement(:css, "input[name='optInOption'][type='radio'][value='" + yesNo +"']")
    puts "Receive Notification Status " + yesNo + " - " + element.selected?.to_s
    return element.selected?
  end

  def isConfirmationPopUpNotPresent()
    return isElementDisappeared(:css, "div.modal-header h3")
  end

  def isSaveButtonPresent()
    return isElementVisible(:css, "button[data-ng-click='modalContent.ok();']")
  end

  def isCancelButtonPresent()
    return isElementVisible(:css, "button[data-ng-click='modalContent.close()']")
  end

  def getConfirmButtonText()
    return getTextForElement(:css, "button[data-ng-click='modalContent.ok();']")
  end

  def getCancelButtonText()
    return getTextForElement(:css, "button[ng-if='!!modalContent.closeButtonText']")
  end


  def clickBPPInfoIconSystolic
    waitForPageToFinishLoading
    clickIndex(:css, ".icon.icon-info", 0)
  end

  def clickBPPInfoIconDiastolic
    waitForPageToFinishLoading
    clickIndex(:css, ".icon.icon-info", 1)
    waitForPageToFinishLoading
  end

  def clickInfoIconOKButton
    waitForPageToFinishLoading
    click(:css, ".btn.btn-default.ng-binding.ng-scope")
    waitForPageToFinishLoading
  end

  def getInfoIconSystolicHeader
    waitForPageToFinishLoading
    return getTextForElement(:css, ".modal-header")
    waitForPageToFinishLoading
  end

  def getInfoIconSystolicParagraph
    waitForPageToFinishLoading
    return getTextForElement(:css, ".modal-body")
    waitForPageToFinishLoading
  end

  def getInfoIconDiastolicHeader
    waitForPageToFinishLoading
    return getTextForElement(:css, ".modal-header")
    waitForPageToFinishLoading
  end

  def getInfoIconDiastolicParagraph
    waitForPageToFinishLoading
    return getTextForElement(:css, ".modal-body")
    waitForPageToFinishLoading
  end
end