require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Menu
  include DriverUtility

  # NEW METHOD
  RIGHT_NAV = ".main-header-btn-right"
  ABOUT = "#about"
  HELP = "#help"  
  RESOURCES = "#resources"
  LAUNCHPAD = "#launchpad"
  LOGIN = "#login"
  LOGOUT = "#logout"

  def nthOptionSelector(n)
    return ".snap-drawer-right ul.panel-menulist li:nth-child(" + n.to_s + ") button"
  end

  # OLD METHOD
  ABOUT_BTN = "about"
  LOGOUT_BTN = "#logout"
  LOGIN_BTN ="login"
  HELP_BTN = "help"
  LAUNCHPAD_BTN = "launchpad"
  
  def initialize(driver)
     @driver = driver
     #@base_url = baseUrl
     #sleep 1.5
  end

  def getMenuHeading
    userMenuHeading = getTextForElement(:css, "div[snap-drawer='right'] div h2")
    #puts "Menu Heading: " + userMenuHeading
    return userMenuHeading
  end
  
  def clickLoginBtn()
    click(:id, LOGIN_BTN)
  end
  
  def clickAboutBtn
    click(:id, ABOUT_BTN)
  end

  def clickResourcesBtn
    click(:css, RESOURCES)
  end

  def clickLogoutBtn
    waitForPageToFinishLoading
    clickRowJquery(LOGOUT_BTN)
  end
  
  def clickHelpBtn
    click(:id, HELP_BTN)
  end

  def clickLaunchpadBtn
    click(:id, LAUNCHPAD_BTN)
  end

  def verifyAboutButtonPresent()
    return getTextForElement(:id, "about")
  end

  def verifyLogoutButtonPresent()
    return getTextForElement(:id, "logout")
  end

  def verifyLoginButtonPresent()
    return getTextForElement(:id, "login")
  end
  
  def verifyLaunchpadButtonPresent()
    return getTextForElement(:id, "launchpad")
  end
  
  def verifyHelpButtonPresent()
    return getTextForElement(:id, "help")
  end

  def isHelpButtonVisible()
    begin
       element = @driver.find_element(:id, "help")
       return element.displayed?
     rescue Exception=>e
       return false
     end
  end

  def isAboutButtonVisible()
    begin
      element = @driver.find_element(:id, "about")
      return element.displayed?
    rescue Exception=>e
      return false
    end
  end

  def isLogOutVisible()
    begin
       element = @driver.find_element(:id, LOGOUT_BTN )
       return element.displayed?
     rescue Exception=>e
       return false
     end
  end
  
  def isLogInVisible()
    begin
       element = @driver.find_element(:id, LOGIN_BTN )
       return element.displayed?
     rescue Exception=>e
       return false
     end 
  end
  
end