require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Main
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  NAV_MENU = "nav-menu-toggle-btn"
  USER_MENU = "#user-menu-toggle-btn"
  Please_Note_Menu = ".btn.btn-primary.accept-btn.pull-right"
    
  def initialize(driver)
     @driver = driver
     #@base_url = baseUrl
     #sleep 1.5
  end

  def getFooterText()
    return getTextForElement(:css, "span[ng-if='userName']")
  end

  def getNotificationText()
    return getTextForElement(:css, ".text-left.modal-body>h3")
  end

  def clickNavMenu
    waitForPageToFinishLoading
    click(:id, NAV_MENU)
  end

  def isNavMenuVisible
    return getElement(:id, NAV_MENU).displayed?
  end
  
  def clickUserMenu
    waitForPageToFinishLoading
    clickJqueryEvent(USER_MENU)
  end
  
  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def pleaseNoteHeader()
    return getTextForElement(:css, Please_Note_Menu)
  end

end