require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../module/MongoUtility"
require_relative 'main'
require_relative 'please_note'

class Login_Screen
  include DriverUtility
  include MongoUtility

  ACCEPT_BUTTON = 'accept-btn'
  USER_NAME = 'AI'
  PASSWORD = 'AI'
  SIGN_IN = "loginButton"
  VERIFY_BUTTON = 'verify-btn'
  
  def initialize(driver)
     @driver = driver
     @pleasenote = PleaseNote.new(@driver)
     @main = Main.new(@driver)
     #@base_url = baseUrl
     #sleep 1.5
  end

  def isUserNameFieldVisible?()
    return @driver.find_element(:id, "name-c").displayed?
  end
  
  def isPasswordFieldVisible?()
    return @driver.find_element(:id, "password").displayed?
  end

  def loginAsVeteran(loginId)
    sleep 3
    !45.times{ break if (is_element_present(:id, USER_NAME)); sleep 1 }
    @driver.find_element(:id, USER_NAME).send_keys(loginId)
    @driver.find_element(:id, PASSWORD).send_keys("pass")
    sleep 1
    click(:id, SIGN_IN)
    sleep 2

    #To check if the ROA screen is present
    if is_element_present(:css, "button[data-theme='b'][aria-disabled='false']") then
      click(:css, "button[data-theme='b'][aria-disabled='false']")

      !15.times{ break if (getPageTitle() == "Review"); sleep 1 }
      click(:id, VERIFY_BUTTON)
      sleep 1
    end

    sleep 3

    #To check if the Time Zone selection screen is present
    waitForPageToFinishLoading
    if is_element_present(:css, "button[ng-click='save()']") then
      #puts "Initializing user Notification Setting and the Time Zone selection."
      sleep 3
      byPassTheNotificationSettingsScreen()
    end

    ####################################################################################################################
    ####################################################################################################################
    ############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###############################
    ####################################################################################################################
    ####################################################################################################################

    #waitForPageToFinishLoading
    sleep 3
    if is_element_present(:css, "input[id='no-show-notice']") then
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept
    end

    ####################################################################################################################
    ####################################################################################################################
    ############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###############################
    ####################################################################################################################
    ####################################################################################################################

    waitForPageToFinishLoading
    if isElementVisible(:id, 'waitingRoomButton')
      click(:id, 'waitingRoomButton')
    end

    waitForPageToFinishLoading
    if @main.getNotificationText == "Notification Settings"
      byPassTheNotificationSettingsScreen
    else
      puts 'Notification Settings page did not exits'
    end


    ##############################################################################################################################
    ##############################################################################################################################
    # TAKE A TOUR IS SHOWING TWO TIMES WHICH IS CAUSING AUTOMATION TO REFRESH TO WORK THIS IS A BUG ONCE FIXED REMOVE BELOW CODE #
    ##############################################################################################################################
    ##############################################################################################################################

    refreshBrowser

    ###############################################################################################################################
    ###############################################################################################################################
    # TAKE A TOUR IS SHOWING TWO TIMES WHICH IS CAUSING AUTOMATION TO REFRESH TO WORK THIS IS A BUG ONCE FIXED REMOVE ABOVE CODE ##
    ###############################################################################################################################
    ###############################################################################################################################

    sleep 5
  end

  def loginSkipROAAndInitialSettings(loginId, firstName, lastName, uniqueId)
    setDefaultROAForPatient(uniqueId)
    setDefaultPreferencesForPatient(uniqueId)
    setDefaultNotificationPreferencesForPatient(uniqueId, firstName, lastName)
    justLogin(loginId)

  end

  def justLogin(loginId) #DO NOT REMOVE. This function supports Verify_ROA_JRNL_32_spec.rb
    waitForPageToFinishLoading
    !45.times{ break if (is_element_present(:id, USER_NAME)); sleep 1 }
    @driver.find_element(:id, USER_NAME).send_keys(loginId)
    @driver.find_element(:id, PASSWORD).send_keys("pass")
    click(:id, SIGN_IN)
  end

  def loginAsVeteranAsFirstTimeUser(loginId)
    !45.times{ break if (is_element_present(:id, USER_NAME)); sleep 1 }
    @driver.find_element(:id, USER_NAME).send_keys(loginId)
    @driver.find_element(:id, PASSWORD).send_keys("pass")
    waitForPageToFinishLoading
    click(:id, SIGN_IN)
    waitForPageToFinishLoading
  end

  def loginAsVeteranAndAcceptROA(dbUserId, userID)
    deleteROAFromTable(dbUserId)

    !45.times{ break if (@driver.find_element(:id, "name-c").displayed?); sleep 1 }
    waitForPageToFinishLoading
    @driver.find_element(:id, USER_NAME).send_keys(userID)
    @driver.find_element(:id, PASSWORD).send_keys("pass")
    @driver.find_element(:id, SIGN_IN).click

    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 }
    click(:css, "#roa div:nth-of-type(3) div fieldset div:nth-of-type(2) a div button" )

    !45.times{ break if (getPageTitle() == "Review"); sleep 1 }
    click(:id, VERIFY_BUTTON)
  end


  def loginAsVeteran01AndAcceptROA()
    loginAsVeteranAndAcceptROA("D123401", "zztest.patient01")
    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept
  end


  def loginAsVeteran01AndDeclineRoaEndsOnLaunchpad()
    deleteROAFromTable("D123401") #zztest.patient01
    waitForPageToFinishLoading
    !45.times{ break if (@driver.find_element(:id, "name-c").displayed?); sleep 1 }

    @driver.find_element(:id, USER_NAME).send_keys("zztest.patient01")
    @driver.find_element(:id, PASSWORD).send_keys("pass")
    @driver.find_element(:id, SIGN_IN).click

    !45.times{ break if (getPageTitle() ==  "Right Of Access"); sleep 1 }
    waitForPageToFinishLoading
    click(:css, "#roa div:nth-of-type(3) div fieldset div:nth-of-type(1) a div button" )
  end

  def passingByTheLandingPage()
    #Verify that user landed on Veteran Template page
    !5.times{ break if (is_element_present(:css, "button[ng-click='beginLogon()']")); sleep 1 }
    #Click DS Logon button
    sleep(1)
    click(:css, "button[ng-click='beginLogon()']")
  end
  
end