require 'rubygems'
require "json"
require 'selenium-webdriver'
require 'rspec'

require_relative  "../pages/login_screen"
require_relative  "../pages/eula"
require_relative  "../pages/landing_screen"
require_relative  "../pages/main"
require_relative  "../module/DriverUtility"
require_relative  "../spec/rspec_helper"

class LoginController

  include DriverUtility

  def initialize(driver)
    @driver = driver
    @login_page = Login_Screen.new(@driver)
    @eula = Eula.new(@driver)
    @landing = Landing_screen.new(@driver)
    @main = Main.new(@driver)
  end

  def login(userId)
    accept_eula

    verify_landing

    login_as(userId)

    check_footer_text
  end

  private
  def accept_eula
    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
  end

  def verify_landing
    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")
  end

  def login_as(login_as)
    @login_page.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @login_page.loginAsVeteran(login_as)
  end

  def check_footer_text
    !45.times { break if (@main.getFooterText() == "Logged in as patient05, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

end