require 'rubygems'
require 'selenium-webdriver'
require 'net/http'
require 'json'
require 'rexml/document'

require_relative  "../module/DriverUtility"

class Launchpad
  include DriverUtility
  
  LOGIN = 'footer-logout-btn'
  LOGOUT = 'footer-logout-btn'
  FOOTER_USER_NAME = 'footer-username'
 
  def initialize(driver)
     @driver = driver
  end
   
  def isLogoutVisible()
    element = @driver.find_element(:id, LOGOUT)
    return element.displayed?
  end
  
  def isLogInVisible()
    element = @driver.find_element(:id, LOGIN)
    return element.displayed?
  end
  
  def clickLogIn()
     click(:id, LOGIN)
     sleep 1.5
  end
  
  def clickLogOut()
    waitForPageToFinishLoading
     click(:id, LOGOUT)
     sleep 1.5
    !45.times{ break if (getTextForElement(:id, FOOTER_USER_NAME) == "Not logged in"); sleep 1 }  
  end
  
  def clickJournal()
    click(:css, "a[href='/my-va-health']")
  end
     
  def getFooterUserName()
    return getTextForElement(:id, FOOTER_USER_NAME )
  end
  
end