require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Landing_screen
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  NAV_MENU = "nav-menu-toggle-btn"
  USER_MENU = "user-menu-toggle-btn"
  LOGIN_BTN = "button[ng-click='beginLogon()']"
  OPT_IN = "button.opt-in"

  def initialize(driver)
    @driver = driver
    #@base_url = baseUrl
    #sleep 1.5
  end

  def clickLogin()
    click(:css, LOGIN_BTN)
  end

  def clickNotificationCount()
    click(:css, ".notifications-count")
  end

  def getNotificationButtonName()
    return getTextForElement(:css, "div.count h3")
  end

  def getWelcomeMessagePart1()
    return getTextForElement(:css, "div[class='starter-template'] p:nth-of-type(2)")
  end

  def getWelcomeMessagePart2()
    return getTextForElement(:css, "div[class='starter-template'] span p")
  end

  def getWelcomeMessagePart3()
    return getTextForElement(:css, "div[class='starter-template'] p:nth-of-type(3)")
  end

  def getWelcomeMessageBeforeLogin()
    return getTextForElement(:css, "h2[class='app-title']")
    puts getTextForElement(:css, "h2[class='app-title']")
  end

  def getDisplayedDate()
    return getTextForElement(:css, "div.welcome div p")
  end

  def getWelcomeMessageAfterLogin()
    return getTextForElement(:css, ".welcome h2")
  end

  def getInformationalTextAfterLogin()
    return getTextForElement(:css, ".access p")
  end

  def getInstructionTextAfterLogin()
    return getTextForElement(:css, ".access span p ")
  end


  def notificationType()
    return getTextForElement(:css, "span.notifications-unread")
  end

  def notificationCount()
    #getTextForElement(:css, "span.notifications-count.ng-binding")
    getTextForElement(:css, "div.container-fluid.page a")
  end

  def notificationWelcomeMessageAfterLogin()
    return getTextForElement(:css, "div.modal-header > h2")
  end

  def notificationsAfterLogin()
    !45.times{ break if (@driver.find_element(:css, "div.container-fluid.page h3").displayed?); sleep 1 }
    return getTextForElement(:css, "div.container-fluid.page h3")
  end

  def receiveNotificationsAfterLogin()
    !45.times{ break if (@driver.find_element(:css, "div > fieldset > legend").displayed?); sleep 1 }
    return getTextForElement(:css, "div > fieldset > legend")
  end

  def isEmailAddressVisible()
    !45.times{ break if (@driver.find_element(:css, "input-text > div > label > span:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "input-text > div > label > span:nth-of-type(1)")
  end

  def isTimeZoneVisible()
    !45.times{ break if (@driver.find_element(:css, "input-select > div > label > span:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "input-select > div > label > span:nth-of-type(1)")
  end

  def isOptInBtnVisible()
    !45.times{ break if (@driver.find_element(:css, "button.opt-in").displayed?); sleep 1 }
    return @driver.find_element(:css, OPT_IN).displayed?
  end

  def notificationInstructionTextAfterLogin()
    return getTextForElement(:css, "div.access > div > span > p")
  end

  def notificationInstructionText1stParagraphAfterLogin()
    return getTextForElement(:css, "div.container-fluid.page div:nth-of-type(2) p:nth-of-type(1)")
  end

  def notificationInstructionText2ndParagraphAfterLogin()
    return getTextForElement(:css, "div.container-fluid.page div:nth-of-type(2) p:nth-of-type(2)")
  end

  def setEmailAddress(email)
    @driver.find_element(:css, "input[name='email']").clear
    if email != nil then
      @driver.find_element(:css, "input[name='email']").send_keys(email)
    end
    sleep 2
  end

  def emailAddressInstructionalText()
    return getTextForElement(:css, "form > span:nth-of-type(2)")
  end

  def preferredEmailInstructionalText()
    return getTextForElement(:css, "form > p")
  end

  def isLoginBtnVisible()
    !45.times{ break if (@driver.find_element(:css, "button[ng-click='beginLogon()']").displayed?); sleep 1 }
    return @driver.find_element(:css, LOGIN_BTN).displayed?
  end

  def getFooterText()
    return getTextForElement(:css, "span[class='ng-scope']" )
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def clickMBB()
    click(:css, "div > a > img")
  end

end