require 'rubygems'
require 'selenium-webdriver'

require_relative "../module/DriverUtility"
require_relative '../helpers/entry_form'


class Images_Documents < EntryForm
  include DriverUtility

  CATEGORY = "select[name='category']"
  FILTERCATEGORY = "select[name='filterCategory']"
  TYPE = "select[name='type']"
  DATE = "input[name='date']"
  STARTDATE = "input[name='startDate']"
  ENDDATE = "input[name='endDate']"
  DATE_OF_DOCUMENT_TEXTFIELD = "input[name='date']"
  INFO_MODAL ="span[id='fileUploadInfo']"
  ATTACH_FILE = "button[name='addAttachment']"
  NOTES = "textarea[name='Notes']"
  X_DELETE = "button[ng-click='deleteAttachment()']"
  CATEGORY_DROPDOWN = "select[name='category']"
  TYPE_DROPDOWN = "select[name='type']"
  ATTACHMENT_BUTTON = "select[name='addAttachment']"



  def initialize(driver)
    @driver = driver
  end

  def clickInfoModal()
    click(:css, INFO_MODAL)
  end

  def deleteAttachedFile()
    click(:css, X_DELETE)
  end

  def isFilterCollapsed
    element = @driver.find_element(:css, "li.filter-toggle button")
    return (element.attribute('title') == 'Expand filter options')
  end

  def isTheFilterButtonVisible()
    return @driver.find_element(:css, "button[ng-click='filter()']").displayed?
  end

  def isTheResetButtonVisible()
    return @driver.find_element(:css, "button[ng-click='reset()']").displayed?
  end

  def clickFilter
    click(:css, 'button[ng-click="filter()"]')
    sleep 2
  end

  def clickReset
    click(:css, 'button[ng-click="reset()"]')
    sleep 2
  end

  def showOrHideFilter()
    click(:css, ".filter-toggle i.pull-left")
    sleep 2
  end

  def selectType(type)
    waitForPageToFinishLoading
    setSelectBoxValue(TYPE_DROPDOWN, type)
  end

  def selectCategory(category)
    waitForPageToFinishLoading
    setSelectBoxValue(CATEGORY_DROPDOWN, category)
  end

  def setDateOfDocument(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, DATE_OF_DOCUMENT_TEXTFIELD).clear
    @driver.find_element(:css, DATE_OF_DOCUMENT_TEXTFIELD).send_keys(date)
  end

  def addAttachmentTemp(file)
    waitForPageToFinishLoading
    click(:css, ATTACHMENT_BUTTON)
    switchWindowToWindowHandleLast
    (File.dirname(__FILE__) + "/../resources/" + file).click
  end



end