require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Hospitalizations_List
  include DriverUtility

  HOSPITALIZATION_LIST = "div.list-table"

  def initialize(driver)
    @driver = driver
  end

  def getHospitalizationsList()
      hospitalizationTable = []
      table = []
      rows = []
      #Keep checking first element in row[0] (which is the startdate) to make
      #sure it is not empty.  If empty, that means table has not been fully
      #loaded/displayed yet
      !45.times do
        table = getElement(:css, HOSPITALIZATION_LIST)
        rows = table.find_elements(:css, "li.ng-scope")
        break if rows.length == 0
        cells = rows[0].find_elements(:css,"span.cell-content")
        #puts "check cell[0] --> [#{cells[0].text.strip}]"
        break if (cells[0].text.strip.length > 0)
        sleep 1
      end
      rows.each_with_index do |line, i|
        hospitalizationRow = []
        #puts "4-ELEMENT-TEXT=[#{line.text}]"
        cells = line.find_elements(:css,"span.cell-content")
        cells.each_with_index do |elem, i|
          #puts "    5-ELEMENT-TEXT=[#{elem.text}]"
          hospitalizationRow << elem.text.strip
        end
        hospitalizationTable << hospitalizationRow
      end
      return hospitalizationTable
  end

end
