require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative "date_filter"

class Hospitalizations_Filter < Date_Filter
  include DriverUtility

  def initialize(driver)
    super(driver)
  end

  def getFilterIconText()
    return getElement(:css, "button[ng-click='toggleFilterState()']").text
  end

  def clickFilterAccordion()
    click(:css, "ul.nav > li > button[ng-click='toggleFilterState()']")
  end

  def getFilterAccordionAltText()
    return getElement(:css, "ul.nav > li > button[ng-click='toggleFilterState()']").attribute("aria-label")
  end

  def getFilterHeader()
    return getElement(:css, "legend.text-left").text
  end

end