require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../helpers/entry_form"

class Hospitalizations < EntryForm
  include DriverUtility

  RANGE_ESTIMATED = "input[ng-model='details.dateEstimated']"
  FACILITY_HOSPITAL = "input[name='facility']"
  HOSPITALIZATION_REASON = "textarea[name='Note']"

  def initialize(driver)
    super(driver)
  end

  ###############
  ### GETTERS ###
  ###############

  def getScreenContent()
    return getElement(:css, "form[name='form']").text
  end

  def getStartDate()
    return getElement(:css, START_DATE).attribute("value")
  end

  def getEndDate()
    return getElement(:css, END_DATE).attribute("value")
  end

  def getSource()
    return getTextForElement(:css, "div.row:nth-child(4) div.col-xs-12 label")
  end

  def getIsRangeEstimated()
    return @driver.find_element(:css, RANGE_ESTIMATED).attribute('checked') ? true : false
  end

  def getFacilityHospital()
    return getElement(:css, FACILITY_HOSPITAL).attribute("value")
  end

  def getHospitalizationReason()
    return getElement(:css, HOSPITALIZATION_REASON).attribute("value")
  end

  def getCountDownDisplayForReason()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end

  ###############
  ### SETTERS ###
  ###############


  def setIsRangeEstimatedYes()
    if !self.getIsRangeEstimated()
      click(:css, RANGE_ESTIMATED)
    end
  end

  def setIsRangeEstimatedNo()
    if self.getIsRangeEstimated()
      click(:css, RANGE_ESTIMATED)
    end
  end

  def setFacilityHospital(facility)
    @driver.find_element(:css, FACILITY_HOSPITAL).clear
    @driver.find_element(:css, FACILITY_HOSPITAL).send_keys(facility)
  end

  def setHospitalizationReason(note)
    @driver.find_element(:css, HOSPITALIZATION_REASON).clear
    @driver.find_element(:css, HOSPITALIZATION_REASON).send_keys(note)
    sleep 0.5
  end

  ################
  ### CLICKERS ###
  ################

  def clickStartDateCalendarBtn()
    click(:css, "div[name='startDate'] span.input-group-btn button")
  end

  def clickEndDateCalendarBtn()
    click(:css, "div[name='endDate'] span.input-group-btn button")
  end

end


























#a.  Dates of Hospitalization :
#a.  Start Date (mm/dd/yyyy, date picker control, required)
#b.  End Date  (mm/dd/yyyy, date picker control, required)
#c.  Start Date must be before End Date otherwise show error (standard location:  'The Start Date must be before the End Date'
#a.  Is this range estimated? Yes/No
#b.  Facility/Hospital  (text, 100 characters, required)
#c.  Reason for Hospitalization (Text � 250 characters)
