require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"

INSTRUCTIONAL_TEXT = "div.important p"
HEALTHCARE_SUMMARY_HEADER = "div.health-report div:nth-of-type(2) h4"
HEALTHCARE_SUMMARY_INSTRUCTIONAL_TEXT = "div.health-report div:nth-of-type(2) p:nth-of-type(1)"
INCLUDE_SUMMARY_CHECKBOX = "#summaryCheckbox"
INCLUDE_SUMMARY_LABEL = "label[for='summaryCheckbox']"

DETAILED_MEDICAL_PERSONAL_DATA_HEADER = "div.health-report div:nth-of-type(3) h4"
DETAILED_MEDICAL_INSTRUCTIONAL_TEXT = "div.health-report div:nth-of-type(3) p"
DETAILED_CONTACT_CHECKBOX = "#detailedContactCheckbox"
DETAILED_CONTACT_LABEL = "label[for='detailedContactCheckbox']"
DETAILED_DIAGNOSIS_CHECKBOX = "#detailedDiagnosisCheckbox"
DETAILED_DIAGNOSIS_LABEL = "label[for='detailedDiagnosisCheckbox']"
DETAILED_MEDICATION_CHECKBOX = "#detailedMedicationCheckbox"
DETAILED_MEDICATION_LABEL = "label[for='detailedMedicationCheckbox']"
DETAILED_ALLERGY_CHECKBOX = "#detailedAllergyCheckbox"
DETAILED_ALLERGY_LABEL = "label[for='detailedAllergyCheckbox']"
DETAILED_SURGERY_CHECKBOX = "#detailedSurgeryCheckbox"
DETAILED_SURGERY_LABEL = "label[for='detailedSurgeryCheckbox']"
DETAILED_HOSPITALIZATION_CHECKBOX = "#detailedHospitalizationCheckbox"
DETAILED_HOSPITALIZATION_LABEL = "label[for='detailedHospitalizationCheckbox']"
DETAIL_PREGNANCY_CHECKBOX = "#detailedPregnancyHistoryCheckbox"
DETAIL_PREGNANCY_LABEL = "label[for='detailedPregnancyHistoryCheckbox']"
DETAIL_FAMILY_HISTORY_CHECKBOX = "#detailedFamilyHistoryCheckbox"
DETAIL_FAMILY_HISTORY_LABEL = "label[for='detailedFamilyHistoryCheckbox']"
DETAIL_MILITARY_HISTORY_CHECKBOX = "#detailedMilitaryHistoryCheckbox"
DETAIL_MILITARY_HISTORY_LABEL = "label[for='detailedMilitaryHistoryCheckbox']"

INCLUDE_PERSONAL_TRACKERS_LABEL = "label[for='trackedDataCheckbox']"
INCLUDE_PERSONAL_TRACKERS_CHECKBOX = "#trackedDataCheckbox"
BP_AND_PULSE_LABEL = "label[for='trackedBloodPressureCheckbox']"
BP_AND_PULSE_CHECKBOX = "#trackedBloodPressureCheckbox"
CHOLESTEROL_LIPID_LABEL = "label[for='trackedCholesterolCheckbox']"
CHOLESTEROL_LIPID_CHECKBOX = "#trackedCholesterolCheckbox"
GLUCOSE_LABEL = "label[for='trackedGlucoseCheckbox']"
GLUCOSE_CHECKBOX = "#trackedGlucoseCheckbox"
HEIGHT_LABEL = "label[for='trackedHeightCheckbox']"
HEIGHT_CHECKBOX = "#trackedHeightCheckbox"
PAIN_LABEL = "label[for='trackedPainCheckbox']"
PAIN_CHECKBOX = "#trackedPainCheckbox"
RESPIRATION_LABEL = "label[for='trackedRespirationCheckbox']"
RESPIRATION_CHECKBOX = "#trackedRespirationCheckbox"
TEMPERATURE_LABEL = "label[for='trackedTemperatureCheckbox']"
TEMPERATURE_CHECKBOX = "#trackedTemperatureCheckbox"
WEIGHT_LABEL = "label[for='trackedWeightCheckbox']"
WEIGHT_CHECKBOX = "#trackedWeightCheckbox"

INCLUDE_OTHER_TRACKERS_LABEL = "label[for='otherTrackedDataCheckbox']"
INCLUDE_OTHER_TRACKERS_CHECKBOX = "#otherTrackedDataCheckbox"
GOALS_LABEL = "label[for='trackedGoalsCheckbox']"
GOALS_CHECKBOX = "#trackedGoalsCheckbox"

REQUIRED_FIELD_FOR_TD_TEXT = "span[ng-if='trackedDataCheckboxSelected']"

TRACKED_DATA = "div.health-report div:nth-of-type(4) h4"
GENERATE_REPORT_BTN = "button[ng-click='generateReport()']"

START_DATE = "input[id='startDate']"
END_DATE = "input[id='endDate']"

class HealthReport
  include DriverUtility

  def initialize(driver)
    @driver = driver

  end

  def isIncludeHealthSummaryChecked()
    element = getElement(:css, INCLUDE_SUMMARY_CHECKBOX)
    element.selected?
  end

  def clickIncludeHealthSummary()
    element = getElement(:css, INCLUDE_SUMMARY_CHECKBOX)
    element.click
  end

  def verifyEmbeddedPDF()
    urlLink = @driver.current_url

    return urlLink.include?('pdf')
  end

  def clickIncludePersonalTrackerCheckBox()
    waitForPageToFinishLoading
    click(:id, 'trackedDataCheckbox')
  end

  def clickBloodPressureAndPulseCheckBox()
    waitForPageToFinishLoading
    click(:id, 'trackedBloodPressureCheckbox')
  end

  def clickGenerateReportButton()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='generateReport()']\")[0].scrollIntoView(true)")
    click(:css, "button[ng-click='generateReport()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def setStartDate(date)
    @driver.find_element(:css, START_DATE).clear
    @driver.find_element(:css, START_DATE).send_keys(date)
  end

  def setEndDate(date)
    @driver.find_element(:css, END_DATE).clear
    @driver.find_element(:css, END_DATE).send_keys(date)
  end

end