require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative "modal_popup"

class HealthFinderModalPopup < Modal_popup

  include DriverUtility

  def initialize(driver)
    super(driver)
  end

  def selectPregnantButton
    click(:css, "div.modal-dialog form[name='statusForm'] input[type='radio'][value='1']")
  end

  def selectNotPregnantButton
    click(:css, "div.modal-dialog form[name='statusForm'] input[type='radio'][value='0']")
  end

  def getModalText
    return getTextForElement(:css, "div.modal-body > p")
  end

  def getModalRadioButtons
    return getElements(:css, "form[name='statusForm'] label > span")
  end

  def isPregnantSelected?
    return getElement(:css, "input[value='1']").selected?
  end

  def isNotPregnantSelected?
    return getElement(:css, "input[value='0']").selected?
  end

end