require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Eula
  include DriverUtility
  
  ACCEPT_BUTTON = "button[ng-click='acceptClicked()']"
  DECLINE_BUTTON = "button[ng-click='declineClicked()']"
  LAUNCHPAD_EULA_ACCEPT = 'accept-btn'
  
  def initialize(driver)
     @driver = driver
     #@base_url = baseUrl
     #sleep 1.5
  end
  
  def getEulaHeading()
    return getTextForElement(:css, "div.panel-heading h2")
  end

  def clickAccept    
    !45.times{ break if (getElement(:css, ACCEPT_BUTTON).displayed?); sleep 1 }
    click(:css, ACCEPT_BUTTON) 
  end

  def clickAcceptMBBEula
    click(:id, LAUNCHPAD_EULA_ACCEPT)
    sleep 1.5
  end

  def clickAcceptLaunchpadEula
    !45.times{ break if (getElement(:id, LAUNCHPAD_EULA_ACCEPT).displayed?); sleep 1 }
    element = getElement(:id, LAUNCHPAD_EULA_ACCEPT)
    element.location_once_scrolled_into_view
    click(:id, LAUNCHPAD_EULA_ACCEPT)
  end
  
  def acceptEulaVisible?()
    !45.times{ break if (is_element_present(:css, ACCEPT_BUTTON)); sleep 1 }
    return isElementVisible(:css, ACCEPT_BUTTON)
  end
  
  def declineEulaVisible?()
    !45.times{ break if (is_element_present(:css, DECLINE_BUTTON)); sleep 1 }
    return isElementVisible(:css, DECLINE_BUTTON)
  end
  
  def clickDeclineEulaButton()
    @driver.find_element(:css, DECLINE_BUTTON).click  
  end
  
  
  def deleteLocalStorage()
    @driver.execute_script("localStorage.clear();")
  end
  
end