require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Error_Validation
  include DriverUtility

  ERROR_MESSAGE_BOX = 'div.validation-summary ul'

  def initialize(driver)
    @driver = driver
  end

  def getValidationSummaryHeader(formName)
    begin
      sleep 3
      return getTextForElement(:css, "[name='" + formName + "'] div.validation-summary h5")
    rescue Exception=>e
      puts "[getValidationSummaryHeader ] Exception: " + e.to_s
      return ""
    end
  end

  def isErrorSummaryElementPresent(formName)
    elements = getElements(:css, "[name='" + formName + "'] div.validation-summary ul li")
    if elements.length > 0
      return true
    else
      return false
    end
  end

  def isErrorMessageDisplayed(formName, errorMessage)

    begin
      isDisplayed = false
      !45.times{ break if (isElementPresentAndVisible(:css, "[name='" + formName + "'] div.validation-summary ul li")); sleep 1 }
      elements = getElements(:css, "[name='" + formName + "'] div.validation-summary ul li")

      eachMessage = "EmptyMsg"
      if elements.length > 0
        for element in elements
          eachMessage = element.text.strip
          # UNCOMMENT TO HELP DEBUG
          # puts "[isErrorMessageDisplayed] " + eachMessage
          # puts "errorMEssage " + errorMessage
          if(eachMessage == errorMessage)
            isDisplayed = true
            break
          end
        end
      else
        puts("No Error Msgs displayed!!!")
      end
      # puts("Can not find expected error [#{errorMessage}] and last error on the list is [#{eachMessage}]") if !isDisplayed
      return isDisplayed
    rescue Exception=>e
      puts "[isErrorMessageDisplayed ] Exception: " + e.to_s
      return false
    end

  end

end