require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative "date_filter"

class Diagnoses_Filter < Date_Filter
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def getScreenContent()
    return getElement(:css, "form.filter-form").text
  end

  def getFilterIconText()
    return getElement(:css, "button[ng-click='toggleFilterState()']").text
  end

  def getFilterButtonLabel()
    return getElement(:css, "button[ng-click='filter()']").text
  end

  def clickCurrentRadioButton()
    click(:css, "input[value='Current']")
  end

  def clickPastRadioButton()
    click(:css, "input[value='Past']")
  end

  def clickAllRadioButton()
    click(:css, "input[value='']")
  end

  def clickFilterAccordion()
    click(:css, "ul.nav > li > button[ng-click='toggleFilterState()']")
  end

  def getFilterAccordionAltText()
    return getElement(:css, "ul.nav > li > button[ng-click='toggleFilterState()']").attribute("aria-label")
  end

  def getFilterRadioLabels()
    return getElement(:css, "div.row").text
  end

  def getFilterHeader()
    return getElement(:css, "legend.text-left").text
  end

  def isCurrentSelected()
    return getElement(:css, "input[value='Current']").selected?
  end

  def isPastSelected()
    return getElement(:css, "input[value='Past']").selected?
  end

  def isAllSelected()
    return getElement(:css, "input[value='']").selected?
  end

end