require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../helpers/entry_form"

class Diagnoses < EntryForm
  include DriverUtility

  ONSET_DATE = "input[id='date']"
  DIAGNOSIS = "input[name='diagnosis']"
  PROVIDER_FACILITY = "input[name='facility']"
  CURRENT_RADIO = "input[value='Current']"
  PAST_RADIO = "input[value='Past']"
  NOTE = "textarea[name='Notes']"
  SOURCE = "label[name='source']"

  def initialize(driver)
    super(driver)
  end

  ###############
  ### GETTERS ###
  ###############

  def getScreenContent()
    return getElement(:css, "entry-form[name='form']").text
  end

  def getOnsetDate()
    return getElement(:css, ONSET_DATE).attribute("value")
  end

  def getDiagnosisElement()
    return getElement(:css, DIAGNOSIS)
  end

  def getDiagnosis()
    return getElement(:css, DIAGNOSIS).attribute("value")
  end

  def getProviderFacility()
    return getElement(:css, PROVIDER_FACILITY).attribute("value")
  end

  def getNote()
    return getElement(:css, NOTE).attribute("value")
  end

  def getSource()
    return getElement(:css, SOURCE).text()
  end

  def getCountDownDisplayForNote()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end

  def isCurrentChecked()
    return @driver.find_element(:css, CURRENT_RADIO).attribute('checked') ? true : false
  end

  def isPastChecked()
    return @driver.find_element(:css, PAST_RADIO).attribute('checked') ? true : false
  end

  ###############
  ### SETTERS ###
  ###############

  def setDiagnosis(diagnosis)
    waitForPageToFinishLoading
    @driver.find_element(:css, DIAGNOSIS).clear
    @driver.find_element(:css, DIAGNOSIS).send_keys(diagnosis)
  end

  def setProviderFacility(facility)
    @driver.find_element(:css, PROVIDER_FACILITY).clear
    @driver.find_element(:css, PROVIDER_FACILITY).send_keys(facility)
  end

  def setCurrentChecked()
    waitForPageToFinishLoading
    click(:css, CURRENT_RADIO)
  end

  def setPastChecked()
    click(:css, PAST_RADIO)
  end

  def setNote(note)
    @driver.find_element(:css, NOTE).clear
    @driver.find_element(:css, NOTE).send_keys(note)
  end

  def setOnsetDate(date)
    @driver.find_element(:css, ONSET_DATE).clear
    @driver.find_element(:css, ONSET_DATE).send_keys(date)
  end

  ################
  ### CLICKERS ###
  ################

  def clickOnsetDateCalendarBtn()
    click(:css, "div[name='date'] > div > div > span > button")
  end

end
