require 'rubygems'
require 'selenium-webdriver'
require 'jquery'

require_relative  "../module/DriverUtility"

START_DATE_CALENDAR_WIDGET = "input[id='startDate'] + span > button"
END_DATE_CALENDAR_WIDGET = "input[id='endDate'] + span > button"
DATE_CALENDAR_WIDGET = "input[name='date'] + span > button"
GOAL_START_DATE_CALENDAR_WIDGET = "input[name='startDate'] + span > button"
GOAL_END_DATE_CALENDAR_WIDGET = "input[name='endDate'] + span > button"
FROM_DATE_CALENDAR_WIDGET = "input[id='startDate'] + span > button"
TO_DATE_CALENDAR_WIDGET = "input[id='endDate'] + span > button"
APPOINTMENT_DATE_CALENDAR_WIDGET = "input[name='date'] + span > button"
DOB_DATE_CALENDAR_WIDGET = "[name='dateOfBirth'] input + span > button"
YEAR_DATE_CALENDAR_WIDGET = "[name='diagnosisDate'] input + span > button"
LAST_ADMINISTERED_DATE_CALENDAR_WIDGET = "input[id='lastAdministered'] + span > button"
LAST_COMPLETED_DATE_CALENDAR_WIDGET = "input[id='lastCompleted'] + span > button"
LAST_TESTED_DATE_CALENDAR_WIDGET =  "input[id='lastCompleted'] + span > button"
LAST_TAKEN_DATE_CALENDAR_WIDGET = "input[id='lastCompleted'] + span > button"
NEXT_DUE_DATE_CALENDAR_WIDGET = "input[id='nextDueDate'] + span > button"
VACCINATION_1_ADMINISTERED_CALENDAR_WIDGET = "input[id='administered-1'] + span > button"
VACCINATION_2_ADMINISTERED_CALENDAR_WIDGET = "input[id='administered-2'] + span > button"
VACCINATION_3_ADMINISTERED_CALENDAR_WIDGET = "input[id='administered-3'] + span > button"
DATE_OF_DOCUMENT_CALENDAR_WIDGET = "input[name='date'] + span > button"

class Date_Picker
  include DriverUtility


  def initialize(driver)
    @driver = driver
  end

  def setMonth(monthNum)
    click(:css, "button[type='month'][data-value='" + monthNum.to_s + "']")
    sleep 2
  end

  def setDay(dayNum)
    click(:css, "button[type='day'][data-value='" + dayNum.to_s + "']")
    sleep 2
  end

  def setYear(yearNum)
    click(:css, "button[type='year'][data-value='" + yearNum.to_s + "']")
    sleep 2
  end

  def setDateFromGUI(month, day, year)
    sleep 1
    setYear(year)
    sleep 1
    setMonth(month)
    sleep 1
    setDay(day)
    sleep 1

    clickSet()
    sleep 1
  end

  def setMonthYearFromGUI(month, year)
    waitForPageToFinishLoading
    setYear(year)
    sleep 1.5
    setMonth(month)
    sleep 1.5
    clickSet()
    sleep 1.5
  end



  def getSetButtonText()
    puts ("[GetSetButton Text ] " + getTextForElement(:css, "#set-btn [aria-hidden]"))
    return getTextForElement(:css, "#set-btn [aria-hidden]")
  end

  def clickStartDateCalendarBtn()
    click(:css, "date-control[field-id='startDate'] .input-group-btn button")
  end

  def clickEndDateCalendarBtn()
    click(:css, "date-control[field-id='endDate'] .input-group-btn button")
  end

  def clickSet()
    click(:css, "#set-btn")
  end

  def clickCloseBtn()
    click(:css, "#date-picker a[ng-click='close($event)']")
  end

  def getSelectedMonth()
    return getTextForElement(:css, "button[type='month'].selected")
  end

  def getSelectedDay()
    return getTextForElement(:css, "button[type='day'].selected")
  end

  def getSelectedYear()
    return getTextForElement(:css, "button[type='year'].selected")
  end

  def convertMonthStrToMonthNumber (monthStr)
    months = ["JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"]
    return months.index(monthStr) + 1
  end

  def areMonthsAfterThisDisabled(monthStr)
    afterThisMonthNum = convertMonthStrToMonthNumber(monthStr) + 1

    monthsValuesDisabled = true
    monthRowCount = getElements(:css, '.month ul li').length

    for i in afterThisMonthNum...monthRowCount
      element = getElement(:css, ".month ul li:nth-of-type(" + i.to_s + ") button")

      if element.attribute("disabled") !=  "true" then
        monthsValuesDisabled = false
        puts "Month after this month was not disabled: " + afterThisMonthNum.to_s

        break
      end
    end

    return monthsValuesDisabled
  end

  def areDaysAfterThisDisabled(dayStr)

    afterThisDayNum = dayStr.to_i + 2
    dayValuesDisabled = true
    dayRowCount = getElements(:css, '.day ul li').length
    for i in afterThisDayNum...dayRowCount
      element = getElement(:css, ".day ul li:nth-of-type(" + i.to_s + ") button")
      if element.attribute("disabled") !=  "true" then
        dayValuesDisabled = false
        puts "Days after this day was not disabled: " + afterThisDayNum.to_s

        break
      end

    end
    return dayValuesDisabled

  end

  def verifyTheYearIsTheLastInList(yearStr)
    displayedYearsCount = getElements(:css, '.year ul li').length

    verifyTheYearIsTheLastInList = true
    for i in 1..displayedYearsCount
      whatYear = getTextForElement(:css, ".year ul li:nth-of-type(" + i.to_s + ") button")

      if whatYear.to_i > yearStr.to_i
        verifyTheYearIsTheLastInList = false
        break
      end

    end

    return verifyTheYearIsTheLastInList
  end

  def verifyAvailableDatesWithinNYears(numberOfYears)
    startDate = getDateNthYeasFromNow(numberOfYears, "%m/%d/%Y")
  end

  def enterDateThroughCalendar(dateString, buttonCssSelector)
    monthNamesArray = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
    waitForPageToFinishLoading
    # split string based on number of /'s
    dateStringArray = dateString.split('/')

    # open widget with css selector on button
    click(:css, buttonCssSelector)
    # depending on array length, use css selectors to click through the widget and enter month, day, year, as needed
    case dateStringArray.length

      #MM/DD/YYYY
      when 3
        waitForPageToFinishLoading
        titleButtonElements = @driver.find_elements(:css, "button[ng-click=\"toggleMode()\"]")
        currentTitleButtonElement = nil
        titleButtonElements.each do |titleButtonElement|
          if titleButtonElement.displayed?
            currentTitleButtonElement = titleButtonElement
            break
          end
        end
        currentTitleButtonElement.click

        waitForPageToFinishLoading
        titleButtonElements = @driver.find_elements(:css, "button[ng-click=\"toggleMode()\"]")
        currentTitleButtonElement = nil
        titleButtonElements.each do |titleButtonElement|
          if titleButtonElement.displayed?
            currentTitleButtonElement = titleButtonElement
            break
          end
        end
        currentTitleButtonElement.click

        matchingYearElement = nil
        while matchingYearElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          yearElements = @driver.find_elements(:css, "span[ng-class=\"{'text-info': dt.current}\"]")
          yearElements.each do |yearElement|
            puts 'in for loop'
            if yearElement.text == dateStringArray[2]
              puts 'found element'
              matchingYearElement = yearElement
              matchingYearElement.click
              break
            end
          end

          if matchingYearElement.nil?
            clickLeftOrRight(yearElements[-1].text.to_i, dateStringArray[2].to_i)
          end
        end

        matchingMonthElement = nil
        while matchingMonthElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          monthElements = @driver.find_elements(:css, "span[ng-class=\"{'text-info': dt.current}\"]")
          monthElements.each do |monthElement|
            puts 'in for loop'
            if monthElement.text == monthNamesArray[dateStringArray[0].to_i - 1]
              puts 'found element'
              matchingMonthElement = monthElement
              matchingMonthElement.click
              break
            end
          end
        end

        matchingDayElement = nil
        while matchingDayElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          dayElements = @driver.find_elements(:css, "span[ng-class=\"{'text-muted': dt.secondary, 'text-info': dt.current}\"]")
          dayElements.each do |dayElement|
            puts 'in for loop'
            if dayElement.text == dateStringArray[1]
              puts 'found element'
              matchingDayElement = dayElement
              matchingDayElement.click
              break
            end
          end
        end

      #MM/YYYY
      when 2
        titleButtonElements = @driver.find_elements(:css, "button[ng-click=\"toggleMode()\"]")
        currentTitleButtonElement = nil
        titleButtonElements.each do |titleButtonElement|
          if titleButtonElement.displayed?
            currentTitleButtonElement = titleButtonElement
            break
          end
        end

        currentTitleButtonElement.click

        matchingYearElement = nil
        while matchingYearElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          yearElements = @driver.find_elements(:css, "span[ng-class=\"{'text-info': dt.current}\"]")
          yearElements.each do |yearElement|
            puts 'in for loop'
            if yearElement.text == dateStringArray[2]
              puts 'found element'
              matchingYearElement = yearElement
              matchingYearElement.click
              break
            end
          end

          if matchingYearElement.nil?
            clickLeftOrRight(yearElements[-1].text.to_i, dateStringArray[2].to_i)
          end
        end

        matchingMonthElement = nil
        while matchingMonthElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          monthElements = @driver.find_elements(:css, "span[ng-class=\"{'text-info': dt.current}\"]")
          monthElements.each do |monthElement|
            puts 'in for loop'
            if monthElement.text == monthNamesArray[dateStringArray[0].to_i - 1]
              puts 'found element'
              matchingMonthElement = monthElement
              matchingMonthElement.click
              break
            end
          end
        end
      #YYYY
      when 1
        matchingYearElement = nil
        while matchingYearElement.nil? do
          waitForPageToFinishLoading
          puts 'in while loop'
          yearElements = @driver.find_elements(:css, "span[ng-class=\"{'text-info': dt.current}\"]")
          yearElements.each do |yearElement|
            puts 'in for loop'
            if yearElement.text == dateStringArray[2]
              puts 'found element'
              matchingYearElement = yearElement
              matchingYearElement.click
              break
            end
          end

          if matchingYearElement.nil?
            clickLeftOrRight(yearElements[-1].text.to_i, dateStringArray[2].to_i)
          end
        end
    end
  end

  def clickLeftOrRight(currentDateInt, targetDateInt)
    leftButtonElements = @driver.find_elements(:css, "button[ng-click=\"move(-1)\"]")
    currentLeftButtonElement = nil
    leftButtonElements.each do |leftButtonElement|
      if leftButtonElement.displayed?
        currentLeftButtonElement = leftButtonElement
        break
      end
    end

    rightButtonElements = @driver.find_elements(:css, "button[ng-click=\"move(1)\"]")
    currentRightButtonElement = nil
    rightButtonElements.each do |rightButtonElement|
      if rightButtonElement.displayed?
        currentRightButtonElement = rightButtonElement
        break
      end
    end

    puts "target date:"
    puts targetDateInt
    puts "current date:"
    puts currentDateInt
    # if target date is less than current date, click left
    if targetDateInt < currentDateInt
      currentLeftButtonElement.click
      # if target date is greater than current date, click right
    elsif targetDateInt > currentDateInt
      currentRightButtonElement.click
    end
  end

  ##### ALL Calendar Widget Start Dates ####

  def enterDateCalendarWidget(date)
    enterDateThroughCalendar(date, DATE_CALENDAR_WIDGET)
  end

  def setStartDateCalendarWidget(date)
    enterDateThroughCalendar(date, START_DATE_CALENDAR_WIDGET)
  end

  def setEndDateCalendarWidget(date)
    enterDateThroughCalendar(date, END_DATE_CALENDAR_WIDGET)
  end

  def setGoalStartDateCalendarWidget(text)
    enterDateThroughCalendar(date, GOAL_START_DATE_CALENDAR_WIDGET)
  end

  def setGoalEndDateCalendarWidget(date)
    enterDateThroughCalendar(date, GOAL_END_DATE_CALENDAR_WIDGET)
  end

  def setNthStepDueDateCalendarWidget(step, date)
    enterDateThroughCalendar(date, "input[name='due_" + step.to_s + "'] + span > button")
  end

  def setNotificationStartDateCalendarWidget(date)
    enterDateThroughCalendar(date, START_DATE_CALENDAR_WIDGET)
  end

  def setFromDateCalendarWidget(date)
    enterDateThroughCalendar(date, FROM_DATE_CALENDAR_WIDGET)
  end

  def setToDateCalendarWidget(date)
    enterDateThroughCalendar(date, TO_DATE_CALENDAR_WIDGET)
  end

  def setAppointmentDateCalendarWidget(date)
    enterDateThroughCalendar(date, APPOINTMENT_DATE_CALENDAR_WIDGET)
  end

  def setDOB(date)
    enterDateThroughCalendar(date, DOB_DATE_CALENDAR_WIDGET)
  end

  def setYear(year)
    enterDateThroughCalendar(year, YEAR_DATE_CALENDAR_WIDGET)
  end

  def setLastAdministeredDateCalendarWidget(date)
    enterDateThroughCalendar(date, LAST_ADMINISTERED_DATE_CALENDAR_WIDGET)
  end

  def setNextDueDateCalendarWidget(date)
    enterDateThroughCalendar(date, NEXT_DUE_DATE_CALENDAR_WIDGET)
  end

  def setLastTakenDateCalendarWidget(date)
    enterDateThroughCalendar(date, LAST_TAKEN_DATE_CALENDAR_WIDGET)
  end

  def setLastCompletedDateCalendarWidget(date)
    enterDateThroughCalendar(date, LAST_COMPLETED_DATE_CALENDAR_WIDGET)
  end

  def setLastTestedDateCalendarWidget(date)
    enterDateThroughCalendar(date, LAST_TESTED_DATE_CALENDAR_WIDGET)
  end

  def setVaccination1AdministeredCalendarWidget(date)
    enterDateThroughCalendar(date, VACCINATION_1_ADMINISTERED_CALENDAR_WIDGET)
  end

  def setVaccination2AdministeredCalendarWidget(date)
    enterDateThroughCalendar(date, VACCINATION_2_ADMINISTERED_CALENDAR_WIDGET)
  end

  def setVaccination3AdministeredCalendarWidget(date)
    enterDateThroughCalendar(date, VACCINATION_3_ADMINISTERED_CALENDAR_WIDGET)
  end

  def setEffectiveDateCalendarWidget(date)
    enterDateThroughCalendar(date, START_DATE_CALENDAR_WIDGET)
  end

  def setDateCalendarWidget(date)
    enterDateThroughCalendar(date, DATE_CALENDAR_WIDGET)
  end

  def setDateOfDocumentCalendarWidget(date)
    enterDateThroughCalendar(date, DATE_OF_DOCUMENT_CALENDAR_WIDGET)
  end

end