require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative '../helpers/entry_form'

class Date_Filter < EntryForm
  include DriverUtility

  def initialize(driver)
    super@driver = driver
    #@base_url = baseUrl
    #sleep 1.5
  end

  def getScreenContent()
    begin
      return getElement(:css, "form.filter-form").text
    rescue
      return ""
    end
  end

  def setDateRangeAndFilter(fromDate, toDate)
    setDateRange(fromDate, toDate)

    #Click the Filter button to apply the date range
    click(:css, "button[ng-click='filter()']")
    sleep 0.5
  end

  def setFromDate (fromDate)
    clearFromDateFiled()
    elStart = getElement(:css, "input[name='startDate']")
    elStart.send_keys(fromDate)
    sleep 1
  end

  def setEndDate (toDate)
    clearEndDateField()
    elEnd = getElement(:css, "input[name='endDate']")
    elEnd.send_keys(toDate)
    sleep 1
  end

  def setDateRange (fromDate, toDate)
    setFromDate (fromDate)
    setEndDate (toDate)
  end

  def clickFilterBtn()
    #Click the Filter button to apply the date range
    click(:css, "button[ng-click='filter()']")
    #sleep 5
  end

  def clickResetBtn()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='reset()']")
  end

  def clickFilterAccordion()
    click(:css, "[ng-click='isFilterCollapsed = !isFilterCollapsed'], [ng-click='toggleFilterState()']")
  end

  def clickStartDateCalendarBtn()
    click(:css, "div[name='startDate'] span.input-group-btn button")
  end

  def clickEndDateCalendarBtn()
    click(:css, "div[name='endDate'] span.input-group-btn button")
  end

  def getStartDate()
    return getTextFromInput(:css, "input[name='startDate']")
  end

  def getEndDate()
    return getTextFromInput(:css, "input[name='endDate']")
  end

  def clearFromDateFiled()
      getElement(:css, "input[name='startDate']").clear
  end

  def clearEndDateField()
      getElement(:css, "input[name='endDate']").clear
  end

  def getRequiredFieldIndicator()
    return getTextForElement(:css, "div[ng-if='requiredExists()']")
  end

  def getStartDatePlaceHolder()
    element = getElement(:css, "input[name='startDate']")
    return element.attribute('placeholder')
  end

  def getEndDatePlaceHolder()
    element = getElement(:css, "input[name='endDate']")
    return element.attribute('placeholder')
  end

  def getEntryDatePlaceHolder()
    element = getElement(:id, "date")
    return element.attribute('placeholder')
  end

  def isFilterAccordionExpanded()
    element = getElement(:css, "ul.nav > li > button > i")
    classVal = element.attribute("class")
    if classVal.to_s.include?("icon-accordion-active")
      return true
    else
      return false
    end
  end

  def getFilterAccordionAltText()
    return getElement(:css, "[ng-click='toggleFilterState()']").attribute("aria-label")
  end

  def getFilterAccordionTitle()
    return getElement(:css, "[ng-click='toggleFilterState()']").attribute("title")
  end

  def getStartDateLabel()
    getTextForElement(:css, "label[for='startDate'] div:nth-of-type(1) span.input-label-content")
  end

  def getEndDateLabel()
    getTextForElement(:css, "label[for='endDate'] div:nth-of-type(1) span.input-label-content")
  end

  def getStatusLabel()
    getTextForElement(:css, "fieldset.status-filter-wrapper legend.text-left")
  end

  def getDateRangeLabel()
    getTextForElement(:css, "fieldset.date-range-control legend.text-left")
  end

  def isStatusChecked(value)
    isThisRadioButtonOrCheckBoxSelected("radio", value, "statusOption")
  end

  def isStartDatePresent()
    is_element_present(:css, "input[name='startDate']")
  end

  def isStartDateEnabled()
    return isElementEnabled?(:css,  "input[name='startDate']")
  end

  def isEndDateEnabled()
    return isElementEnabled?(:css,  "input[name='endDate']")
  end

  def isStartDateRequiredField()
    element = getElement(:css, "input[name='startDate']")
    required = element.attribute("required")
    if required == "true"
      return true
    else
      return false
    end
  end

  def isEndDateRequiredField()
    element = getElement(:css, "input[name='endDate']")
    required = element.attribute("required")
    if required == "true"
      return true
    else
      return false
    end
  end

  def isEndDatePresent()
    is_element_present(:css, "input[name='endDate']")
  end

  def isFilterButtonPresent()
    is_element_present(:css, "button[ng-click='filter()']")
  end

  def isFilterButtonVisible()
    isElementVisible(:css, "button[ng-click='filter()']")
  end

  def isResetButtonPresent()
    is_element_present(:css, "button[ng-click='reset()']")
  end

  def isResetButtonVisible()
    isElementVisible(:css, "button[ng-click='reset()']")
  end

  def getFilterButtonLabel()
    return getElement(:css, "button[ng-click='filter()']").text
  end

  def getResetButtonLabel()
    return getElement(:css, "button[ng-click='reset()']").text
  end

  def isDefaultDateRange()

    startDate = getStartDate()
    endDate = getEndDate()

    todayDate = getDateNthDaysAgo(0, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")

    if endDate == todayDate and startDate == thirtyDaysAgo then
      return true
    end

    return false
  end

end