require 'rubygems'
require 'selenium-webdriver'

require_relative "../helpers/entry_form"

class PreventiveService_Settings < EntryForm

  MODAL_HEADING = "Preventive Services - Display Options"
  GEAR_ICON = "button[title='Preventive Services Settings']"

  def initialize(driver)
    super(driver);
  end

  def getHeading()
    return getTextForElement(:css, "div.modal-header h3")
  end

  def getScreenContent()
    #return getTextForElement(:css, "div.modal-body")
    return getTextForElement(:css, 'div.modal-content')
  end

  def toggleCPSReminder(nIndex)
    click(:css, "form[name='settingsForm'] > div > div:nth-child(#{nIndex}) > label > input")
  end

  def isCPSReminderSelected(nIndex)
    return getElement(:css, "form[name='settingsForm'] > div > div:nth-child(#{nIndex}) > label > input").selected?
  end

  def getCPSReminderName(nIndex)
    return getElement(:css, "form[name='settingsForm'] > div > div:nth-child(#{nIndex}) > label > strong").text
  end

  def clickTheGearIcon()
    click(:css, GEAR_ICON)
  end

  def getCPSReminderCount()
    return getElements(:css, "form[name='settingsForm'] div.col-xs-12").length
  end

  def clickCancelButton()
   click(:css, "[ng-click='cancel()']")
  end

  def clickSaveButton()
   click(:css, "[ng-click='save()']")
  end

  def getNoResultsMessage()
   return getElement(:css, "list-table div[ng-bind-html='noResultsMessage']").text
  end

  def getInstructionalText()
    return getTextForElement(:css, "div.modal-body > p")
  end

  def getModalFormText()
    return getTextForElement(:css, "form[name='settingsForm']")
  end

  def isModalVisible()
    return isElementPresentAndVisible(:css, "div.modal-content")
  end

end