require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"

class Resources
  include DriverUtility

  #selector
  URGENT_GROUP = ".alert-urgent"
  URGENT_LABEL = URGENT_GROUP + " h4"
  MODAL_ITEM = ".modal-item"
  NAME = ".mo-title"
  DESCRIPTION =".mo-desc"
  NAME_LINK = DESCRIPTION + " [href]"
  ADDITIONAL_INFO = ".mo-info"
  PHONE = ".mo-phone" 

  #text
  URGENT_LABEL_TEXT = "Urgent Contacts"

  def initialize(driver)
    @driver = driver
  end

  def nthModalItem(n)
    return ".modal-body > div:nth-of-type(" + n.to_s + ")"
  end

  def nthUrgentModalItem(n)
    return URGENT_GROUP + " > div:nth-of-type(" + n.to_s + ")"
  end

end
