require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"

require_relative "healthcare_contacts"

class OrganizationHealthCareContacts < HealthCareContacts

  def initialize(driver)
    super(driver);
  end

  def setOrganizationType(value)
    makeSelection("select[name='association']", value)
  end

  def getOrganizationType()
    return getSelectedOptionValue(:css, "select[name='association']")
  end

  def setOrganizationName(text)
    setInputText('addressName', text);
  end

  def getOrganizationName()
    return getTextFromInput(:css, "input[name='addressName']")
  end

end