require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/filter"
require_relative  "../../module/DriverUtility"

class Insurance_Contacts_Filter

  include DriverUtility
  include Filter

  COMPANY_NAME = "input[name='companyName']"
  COMPANY_TYPE = "select[name='type']"

  def initialize(driver)
    @driver = driver
  end

  def getCompanyName()
    return getElement(:css, COMPANY_NAME).attribute("value")
  end

  def getCompanyType()
   return getSelectedOptionText(:css, COMPANY_TYPE)
  end

  def setCompanyName(text)
    @driver.find_element(:css, "input[name='companyName']").clear
    @driver.find_element(:css, "input[name='companyName']").send_keys(text);
  end

  def setCompanyType(text)
    selectTypeByText('type',text)
  end

  def getSelectedOptionText(how, what)
    select = Selenium::WebDriver::Support::Select.new(@driver.find_element(how,  what))
    option = select.first_selected_option
    return option.text
  end

 def selectTypeByText(fieldName, type)
    #puts "Type is [#{type}]"
   @driver.execute_script("$(\"select[name='"+ fieldName + "']\").scope().ngModel = '" + type + "'")
   @driver.execute_script("$(\"select[name='"+ fieldName + "']\").scope().$digest()")
  end
end