require 'rubygems'
require 'selenium-webdriver'


require_relative  "../../module/DriverUtility"


class Healthcare_Contacts_List
  include DriverUtility

  HEALTHCARE_CONTACTS_LIST = "div.list-table"
  RESULT_AREA = "list-table[class='ng-isolate-scope']"

  def initialize(driver)
    @driver = driver
  end

  def getContactsListHeaders()
    table = []
    rows = []
    !10.times do
      table = getElement(:css, HEALTHCARE_CONTACTS_LIST)
      element = table.find_element(:css,".header")
      cells = element.text.split("\n")
      if cells[0] != nil
        break if (cells[0].strip.length > 0)
      end
      sleep 1
    end

    begin
      table = getElement(:css, HEALTHCARE_CONTACTS_LIST)
      element = table.find_element(:css,".header")
      return element.text.split("\n")
    rescue Exception=>e
      puts "Exception " + e.to_s
      return []
    end
  end



  def getContactsCount()
    holdRow = -1
    rows = []
    while holdRow != rows.length do
      holdRow = rows.length
      sleep 1.0
      rows = getElement(:css, HEALTHCARE_CONTACTS_LIST).find_elements(:css, "li.ng-scope")
    end
    return rows.length
  end


  def getContactsList()
      contactsTable = []
      table = []
      rows = []
      !45.times do
        table = getElement(:css, HEALTHCARE_CONTACTS_LIST)
        rows = table.find_elements(:css, "li.ng-scope")
        break if rows.length == 0
        cells = rows[0].find_elements(:css,"span.cell-content")
        break if (cells[0].text.strip.length > 0)
        sleep 1
      end
      rows.each_with_index do |line, i|
        contactRow = []
        #puts "4-ELEMENT-TEXT=[#{line.text}]"
        cells = line.find_elements(:css,"span.cell-content")
        cells.each_with_index do |elem, i|
          #puts "    5-ELEMENT-TEXT=[#{elem.text}]"
          contactRow << elem.text.strip
        end
        contactsTable << contactRow
      end
      return contactsTable
  end

  def getFilterResultArea
    !5.times{ break if (getTextForElement(:css, RESULT_AREA) == "No results found."); sleep 1 }
    return getTextForElement(:css, RESULT_AREA)
  end

  def getContentByRowNumber(row)
    table = getElement(:css, HEALTHCARE_CONTACTS_LIST)
    rows = table.find_elements(:css, "li.ng-scope")
    return rows[row].text
  end

  def clickAddButton()
    click(:css, "button[title='Add']")
  end

  def isAddButtonVisible()
    return isElementVisible(:css, "button[title='Add']")
  end

  def clickOnContactByRow(row)
    table = getElement(:css, HEALTHCARE_CONTACTS_LIST)
    rows = table.find_elements(:css, "li.ng-scope")
    waitForPageToFinishLoading
    rows[row].click
  end

end
