require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/filter"
require_relative  "../../module/DriverUtility"

class Healthcare_Contacts_Filter
  include DriverUtility
  include Filter

  def initialize(driver)
    @driver = driver
  end

  def clickOrganizationRadioButton()
    waitForPageToFinishLoading
    click(:css, "input[value='Organization']")
  end

  def clickProviderRadioButton()
    click(:css, "input[value='Individual Provider']")
  end

  def clickAllRadioButton()
    click(:css, "input[value='Healthcare']")
  end

  def isProviderSelected()
    return getElement(:css, "input[value='Individual Provider']").selected?
  end

  def isOrganizationSelected()
    return getElement(:css, "input[value='Organization']").selected?
  end

  def isAllSelected()
    return getElement(:css, "input[value='Healthcare']").selected?
  end

end