require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"
require_relative "entry_screen"
require_relative '../../globalized'
class HealthCareContacts < EntryScreen



  def initialize(driver)
    super(driver);
  end

  def selectRadio(value)
    sleep(5)
    click(:css, "input[name='type'][type='radio'][value='" + value + "']")
  end

  def selectProvider
    selectRadio('Individual Provider');
  end

  def selectOrganization
    selectRadio('Organization')
  end


  def isProviderSelected
    if getElement(:css, "input[name='type'][type='radio'][value='Individual Provider']").attribute("checked") == "true"
        return true
    elsif getElement(:css, "input[name='type'][type='radio'][value='Organization']").attribute("checked") == "true"
        return false
    else
        return nil
    end
  end

  def isOrganizationSelected
    if getElement(:css, "input[name='type'][type='radio'][value='Organization']").attribute("checked") == "true"
        return true
    elsif getElement(:css, "input[name='type'][type='radio'][value='Individual Provider']").attribute("checked") == "true"
        return false
    else
        return nil
    end
  end


  def selectType(fieldName, type)
    #puts "Type is [#{type}]"
    select = getElement(:css, "select[name='"+ fieldName + "']");
    makeSelection(select, type);
  end

  def selectTypeByText(fieldName, type, modelValue)
    #puts "Type is [#{type}]"
    select = getElement(:css, "select[name='"+ fieldName + "']");
    options = select.find_elements(:tag_name, "option");
    options.each_with_index do |e, i|
      #puts "Checking option <#{e.text}>"
      if e.text == type
        @driver.execute_script("$('.container-fluid').css('overflow', 'auto');")
        e.click
        @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
      end
    end
  end

  def makeSelection(elemselector,  value)
        # selectType('prefix',type);
    waitForPageToFinishLoading
    field = getElement(:css, elemselector)
    option = field.find_element(:css, "[value='" + value + "']")
    if option != nil
      select = Selenium::WebDriver::Support::Select.new(field)
      select.select_by(:value, value)
    end
  end

  #This reusuable method is using Jquery. Css alone will not work with dropdowns the page jumps
  def makeSelection(elemselector, value)
    elemselector = elemselector.gsub("'", %q(\\\'))
    @driver.execute_script("$('" + elemselector + "').scope().ngModel = '" + value + "'")
    @driver.execute_script("$('" + elemselector + "').scope().$digest()")
  end


  def setTextArea(field, text)
    begin
      element = @driver.find_element(:css, "textarea[name='" + field + "']")
      #puts "found element #{field}"
      element.clear;
      element.send_keys(text);
    rescue Exception => e
      puts "#{e}"
      setInputText(field, text)
    end
  end

  def setInputText(field, text)
      waitForPageToFinishLoading
      @driver.find_element(:css, "input[name='" + field + "']").clear;
      @driver.find_element(:css, "input[name='" + field + "']").send_keys(text);
  end

  def setPhoneInputText(field, text)
      elem = @driver.find_element(:css, "input[name='" + field + "']") 
      elem.click
      elem.clear
      elem.send_keys "\u0008"
      text.split("").each do |i|
        elem.send_keys i
      end
  end



  def getPrimaryPhone()
    return getTextFromInput(:css, "input[name='primaryPhone']")
  end

  def setPrimaryPhone(text)
    setPhoneInputText('primaryPhone', text)
  end


  def getPrimaryPhoneType()
    return getSelectedOptionValue(:css, "select[name='primaryPhoneType']")
  end

  def setPrimaryPhoneType(value)
    makeSelection("select[name='primaryPhoneType']", value)
  end

  def getOtherPhone(number)
    return getTextFromInput(:css, "input[name='otherPhone#{number}']")
  end

  def setOtherPhone(number, text)
    setPhoneInputText("otherPhone#{number}", text)
  end

  def setOtherPhoneType(number, value)
    makeSelection("select[name='otherPhoneType#{number}']", value)
  end

  def getOtherPhoneType(number)
    return getSelectedOptionValue(:css, "select[name='otherPhoneType#{number}']")
  end

  def clickAddPhoneButton()
    click(:css, 'button[ng-click="addPhone()"]')
  end

  def setCountry(type)
    selectTypeByText('addressCountry',type, "details.address.country");
  end

  def getCountry()
    return getSelectedOptionText(:css, "select[name='addressCountry']")
  end


  def setAddressLineOne(text)
    setInputText('addressLineOne', text)
  end

  def getAddressLineOne()
    return getTextFromInput(:css, "input[name='addressLineOne']")
  end

  def setAddressLineTwo(text)
    setInputText('addressLineTwo', text)
  end

  def getAddressLineTwo()
    return getTextFromInput(:css, "input[name='addressLineTwo']")
  end

  def setCity(text)
    setInputText('addressCity', text)
  end

  def getCity()
    return getTextFromInput(:css, "input[name='addressCity']")
  end

  def setState(type)
    selectTypeByText('addressStateAbbreviation',type, "details.address.stateAbbrev");
  end

  def getState()
    return getSelectedOptionText(:css, "select[name='addressStateAbbreviation']")
  end

  def getStateByValue()
    return getSelectedOptionValue(:css, "select[name='addressStateAbbreviation']")
  end


  def setStateProvince(type)
    setInputText('addressStateProvince',type);
  end

  def getStateProvince()
    return getTextFromInput(:css, "input[name='addressStateProvince']")
  end


  def setZipPostalCode(text)
    setInputText('addressZipPostalCode', text);
  end

  def getZipPostalCode()
    return getTextFromInput(:css, "input[name='addressZipPostalCode']")
  end

  def setWebsite(text)
    setInputText('addressWebsite', text);
  end

  def getWebsite()
    return getTextFromInput(:css, "input[name='addressWebsite']")
  end

  def setNote(text)
    setTextArea('note', text);
  end

  def getNote()
    return getTextFromInput(:css, "textarea[name='note']")
  end

  def getStateLabel
    if getTextForElement(:id, "stateSelectLabel") != ""
      #puts "getStateLabel----1try"
      return getTextForElement(:id, "stateSelectLabel")
    else
      #puts "getStateLabel----2try"
      return getTextForElement(:css, "span[name='addressStateProvinceLabel']")
    
    end
  end  


  def clickDeleteOtherPhoneButton(number)
    click(:css, "button[name='deletePhone#{number}']")
  end

  def isDeleteOtherPhoneButtonVisible(number)
    return isElementPresentAndVisible(:css, "button[name='deletePhone#{number}']")
  end

  def getDeleteOtherPhoneButtonAltText(number)
    return getElement(:css, "button[name='deletePhone#{number}']").attribute("aria-label")
  end


  def setEmail(text)
    setInputText('email', text);
  end

  def getEmail()
    return getTextFromInput(:css, "input[name='email']")
  end

  def isRequired(field)
    return getElement(:css, field).attribute("required") ? true : false
  end


# ---- TODO : Move functions below to DriverUtility.rb ------------------------------------


  def getCountDownDisplayForNote()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end



  def getSelectedOptionText(how, what)
    select = Selenium::WebDriver::Support::Select.new(@driver.find_element(how,  what))
    option = select.first_selected_option
    return option.text
  end


  def stripSelectTextFromScreen(mainList, selectFields)
    tmpList = mainList
    selectFields.each do |  f |
      tmpList = removeSubsetFromList( tmpList, getPulldownValues(f))
    end
    return tmpList
  end

  def getPulldownValues(fieldName)
    #puts "Type is [#{type}]"
    select = getElement(:css, "select[name='"+ fieldName + "']")
    options = select.find_elements(:tag_name, "option")
    values = []    
    options.each_with_index do |e, i|
        #puts "Checking option <#{e.text}>"
        values << e.text
    end
    #puts "getPulldownValues=[#{values}]"
    return values
  end


  def removeSubsetFromList(mainList, subsetList)
    if subsetList.length == 0
       return mainList
    end
    startPos = mainList.index(subsetList[1])
    #puts "removeSubsetFromList startPos=[#{startPos}] [#{subsetList[1]}]"
    retArray = []
    if startPos == nil
       retArray = mainList
    else
       retArray = mainList[0..startPos-2]
       # retArray.each_with_index do | ee, j|
       #   puts "retArray(1)=[#{j}]  [#{ee}]"
       #end
       endPos = 0
       pos = startPos
       subsetList.each_with_index do |e, i|
         if i > 0 
           #puts "comparing [#{i}] [#{e}] with  [#{mainList[startPos]}] startPos=[#{startPos}] endPos=[#{endPos}] pos=[#{pos}]"
           if e != mainList[pos]
              #puts "endPos = #{endPos}"
              break
           end
           pos = pos + 1
           endPos = endPos + 1
         end
       end
       endPos = endPos + startPos
       #puts "endPos=[#{endPos}] after loop"
       for i in endPos..(mainList.length-1)
         retArray << mainList[i]
       end
       #retArray.each_with_index do | ee, j|
       #   puts "retArray(2)=[#{j}]  [#{ee}]"
       #end
    end

    return retArray

  end

# ---- TODO : Move functions above to DriverUtility.rb ------------------------------------


  protected :selectType
  protected :setTextArea
  protected :setInputText

end