require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"



class EntryScreen
  include DriverUtility

  SAVE_BUTTON   = "button[ng-click='confirmSave()']"
  CANCEL_BUTTON = "button[ng-click='cancel()']"
  DELETE_BUTTON = "button[ng-click='delete()']"

  def initialize(driver)
    @driver = driver;
  end

  def clickSave
    clickJquery(SAVE_BUTTON)
  end

  def clickCancel
    click(:css, CANCEL_BUTTON);
  end

  def clickDelete
    click(:css,DELETE_BUTTON)
  end

  def isSaveButtonVisible()
    return is_element_present(:css, "button[ng-click='save()']")
  end

  def isDeleteButtonVisible()
    return is_element_present(:css, "button[ng-click='delete()']")
  end

  def isCancelButtonVisible()
    return is_element_present(:css, "button[ng-click='cancel()']")
  end

  def getMainHeader()
    return getTextForElement(:css, ".main-title[aria-hidden]")
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def getScreenContent()
    return getElement(:css, "form[name='entryForm']").text
  end


  def validateTextMax(&getter)

  end

  def validateTextMin(&getter)

  end
end