require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative '../helpers/entry_form'

class Contacts < EntryForm
  include DriverUtility
  HEALTHCARE_CONTACTS_BUTTON = "button.healthcare-contacts"
  INSURANCE_CONTACTS_BUTTON = "button.insurance-contacts"
  PERSONAL_CONTACTS_BUTTON = "button.personal-contacts"
  COMMUNICATIONS_LOG_BUTTON = "button.communications-log"
  EFFECTIVE_DATE_TEXTFIELD = "input[id='startDate']"
  END_DATE_TEXTFIELD = "input[id='endDate']"
  COMPANY_TEXTFIELD = "input[name='company']"
  SUBJECT_TEXTFIELD = "input[name='logTask']"
  DATE_TEXTFIELD = "input[id='date']"
  TYPE_DROPDOWN = "select[name='logActivity']"
  
  LEARN_BUTTON = "i.icon-gradcap"
  BACK_BTN = "i.glyphicon"
  I_BTN = "i.icon-info"
  ADD_BTN = "i.icon.icon-add"

  def initialize(driver)
    @driver = driver
  end
  
  def getNthContactsFeatureName(number)
    return getTextForElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") ")
  end


  ######################  Items Visibilities ##################################


  def isInsuranceContactsButtonVisible()
    return isElementVisible(:css, INSURANCE_CONTACTS_BUTTON)
  end

  def isPersonalContactsButtonVisible()
    return isElementVisible(:css, PERSONAL_CONTACTS_BUTTON)
  end

  def isCommunicationsLogButtonVisible()
    return isElementVisible(:css, COMMUNICATIONS_LOG_BUTTON)
  end

  def isHealthcareButtonVisible()
    return isElementVisible(:css, HEALTHCARE_CONTACTS_BUTTON)
  end

  def isLearnButtonVisible()
    return isElementVisible(:css, LEARN_BUTTON)
  end
  
  def isIBtnVisible()
    return isElementVisible(:css, I_BTN)
  end

  def isAddVisible()
    return isElementVisible(:css, ADD_BTN)
  end

  def isNthIconDisplayedLeftOfItem(number)
   element = getElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") span div div :nth-child(1)")
   return ( element.tag_name == "i" ? true: false)
  end


######################  Page Actions ##################################
  def clickHealthCareContacts()
    click(:css, HEALTHCARE_CONTACTS_BUTTON)
  end
  
  def clickInsuranceContacts()
    waitForPageToFinishLoading
    click(:css, INSURANCE_CONTACTS_BUTTON)
  end
  
  def clickPersonalContacts()
    waitForPageToFinishLoading
    click(:css, PERSONAL_CONTACTS_BUTTON)
  end
  
  def clickCommunicationsLog()
    waitForPageToFinishLoading
    click(:css, COMMUNICATIONS_LOG_BUTTON)
  end

  def clickLearn()
    click(:css, LEARN_BUTTON)
  end

  def clickBackButton()
    click(:css,  BACK_BTN)
  end

  def clickIButton()
    click(:css, I_BTN)
  end

  def clickAddButton()
    sleep(5)
    click(:css, ADD_BTN)
  end
  
########### PAGE HELPERS ############################  
  
  ######  Common: According related helpers
 
  def collapseAccordionByHeading(heading)
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-active')
  end

  def getCollapsedAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Expand\n")
    return label[1]

  end

  def isAccordionCollapsed(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    if(labelText.include?("Expand"))
      return true
    else
      false
    end
  end


  def getAccordionAltText(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')
  end

  def getAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Collapse\n")
    return label[1]
  end

  def getAccordionInfoTextByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div p.ng-binding ')
  end


  ######  Common: Arrows related helpers
  
  def isRightArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")
  
    if (classValue.include?("icon-accordion-static"))
      return true
    else
      return false
    end
  
  end
  
  def isDownArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")
  
    if (classValue.include?("icon-accordion-active"))
      return true
    else
      return false
    end
  
  end

  ###### Textfields ###########

  def setEffectiveDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, START_DATE).clear
    @driver.find_element(:css, START_DATE).send_keys(date)
  end

  def setEndDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, END_DATE).clear
    @driver.find_element(:css, END_DATE).send_keys(date)
  end

  def setDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, DATE_TEXTFIELD).clear
    @driver.find_element(:css, DATE_TEXTFIELD).send_keys(date)
  end

  def setCompany(name)
    waitForPageToFinishLoading
    @driver.find_element(:css, COMPANY_TEXTFIELD).clear
    @driver.find_element(:css, COMPANY_TEXTFIELD).send_keys(name)
  end

  def setSubject(name)
    waitForPageToFinishLoading
    @driver.find_element(:css, SUBJECT_TEXTFIELD).clear
    @driver.find_element(:css, SUBJECT_TEXTFIELD).send_keys(name)
  end

  ###### Dropdown #######

  def selectType(name)
    waitForPageToFinishLoading
    setSelectBoxValue(TYPE_DROPDOWN, name)
  end

  ######  End of Common

  #### InsuranceContacts 
  
  ########### End of InsuranceContacts

  


end