require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../pages/date_filter"


class Communications_Log_Filter < Date_Filter
  include DriverUtility

  def getScreenContent()
    return getElement(:css, "form.filter-form").text
  end

  def getFilterIconLabel()
    #return getElement(:css, "button[class='btn btn-default']").text
    filterLabel = getElement(:css, "button[class='btn btn-default']").text
    filterTitle = getElement(:css, "button[ng-click='toggleFilterState()']").attribute("title")
    return "#{filterLabel}\n#{filterTitle}"
  end

  def getFilterButtonLabel()
    return getElement(:css, "button[ng-click='filter()']").text
  end

  def isRequiredFieldLabelHasStar()
    if getElement(:css, "span[ng-if='isRequired']").text == "*"
      return true 
    else
      return false
    end
    
  end
  
  def clickOnFilterIcon()
    click(:css, "button[ng-click='toggleFilterState()']")
  end

  def isFilterExpanded()
    return is_element_present(:css, "i[class='icon pull-left icon-accordion-active']")
  end

  def getStartDateLabel()
    return getElement(:css, "label[for='startDate']").text
  end

  def getEndDateLabel()
    return getElement(:css, "label[for='endDate']").text
  end


  def isFilterCollapsed()
    return is_element_present(:css, "i[class='icon pull-left icon-accordion-static']")
  end


  def isStartDateVisible()
    return isElementVisible(:css, "input[name='startDate']")
  end

  def isEndDateVisible()
    return isElementVisible(:css, "input[name='endDate']")
  end



end