require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative "date_filter"

class Communications
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  EVENT_TITLE = "eventTitle"
  
  ADD_LOG_ENTRY_TITLE  = "Add Communications Log Entry"
  EDIT_LOG_ENTRY_TITLE = "Edit Communications Log Entry"
  
  ADD_LOG_ENTRY_BUTTON = "button[ng-click='getDetails()']"#{}"button[aria-label='Add']"
  
  SAVE_BUTTON   = "button[ng-click='confirmSave()']"
  CANCEL_BUTTON = "button[ng-click='cancel()']"
  DELETE_BUTTON = "button[ng-click='delete()']"
  START_DATE = "input[id='startDate']"
  END_DATE = "input[id='endDate']"

  CELL_CLASS = ".cell-content"
  SUBJECT_COLUMN_ID = 0
  CONTACT_COLUMN_ID = 1
  COMMUNICATION_TYPE_COLUMN_ID = 2
  DATE_COLUMN_ID = 3
    
  
  def initialize(driver)
    @driver = driver
    @date_filter = Date_Filter.new(@driver)
  end

  def getScreenContent()
    return getElement(:css, "form[name='entryForm']").text
  end

  def getListHeader()
    return getElement(:css, "div[class='header']").text
  end
  
  def getTitle()
    return getTextForElement(:css, TITLE)
  end
  
  def isAddCommunicationBtnVisible()
    return isElementVisible(:css, ADD_LOG_ENTRY_BUTTON)
  end
  
  def clickFilter
    click(:css, 'button[ng-click="filter()"]')
  end
  
  def clickAddCommunicationBtn()
    waitForPageToFinishLoading
    click(:css, ADD_LOG_ENTRY_BUTTON)
    waitForPageToFinishLoading
  end

  def clickSaveNewBtn()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='saveNewItem()']")
  end
  
  def clickSaveButton()
    click(:css, SAVE_BUTTON)
  end

  def clickCancelButton()
    click(:css, CANCEL_BUTTON)
  end

  def clickDeleteButton()
    click(:css, DELETE_BUTTON)
  end

  def isDeleteButtonVisible()
    #return isElementVisible(:css, DELETE_BUTTON)
    return is_element_present(:css, DELETE_BUTTON)
  end

  def isCancelButtonVisible()
    return is_element_present(:css, CANCEL_BUTTON)
  end

  def isSaveButtonVisible()
    return is_element_present(:css, SAVE_BUTTON)
  end


  def clickNthCommunicationLog(number)
    waitForPageToFinishLoading
    getCommunicationsLogEntry(number).click
    #click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def clickThisCommunicationLogEntry(rowEntry)
    rowEntry.click
    #click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end
   
  def getFilterStartDate()
      return getTextFromInput(:css, "input[name='startDate']")
  end
  
  def getFilterEndDate()
      return toDate = getTextFromInput(:css, "input[name='endDate']")
  end
            
  def setDate(dateStr, cssPath)
    #cssPath could be e.g. "input[name='date']"

    @driver.find_element(:css, cssPath).clear
    @driver.find_element(:css, cssPath).send_keys(dateStr)
    sleep 0.5
  end

  def selectType(type)
    #puts "Type is [#{type}]"
    @driver.execute_script("$(\"select[name='logActivity']\").scope().ngModel = '" + type + "'")
    @driver.execute_script("$(\"select[name='logActivity']\").scope().$digest()")
  end

  def setSubject(subject)
    @driver.find_element(:css, "input[name='logTask']").clear
    @driver.find_element(:css, "input[name='logTask']").send_keys(subject)
  end

  def setWho(who)
    @driver.find_element(:css, "input[name='logContact']").clear
    @driver.find_element(:css, "input[name='logContact']").send_keys(who)
  end

  def setNote(note)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(note)
  end

  def setDateRangeAndFilter(fromDate, toDate)
    @date_filter.setDateRangeAndFilter(fromDate, toDate)
    sleep 5
  end
  
  #Check if all log entries are within range that was specified in startDate and endDate fields
  def isDatesWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDatesWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate
    
    logCount = getCommunicationsLogCount()
    isValid = true
      
    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")
   
    for i in 1..logCount
      logDate = getNthDateInCommList(i)
      logDateObj = DateTime.strptime(logDate, "%m/%d/%Y")
      
      #puts "logDate " + logDate
      if logDateObj <= fromDateObj and logDateObj >= toDateObj then
        isValid = false
        break
      end
    end
    
    return isValid
    
  end

  def getDateInForm()
    return getTextFromInput(:css, ".page #date")
  end
  
  def getSubjectInForm()
    return getTextFromInput(:css, "input[name='logTask']")
  end
  
  def getContactInForm()
      return getTextFromInput(:css, "input[name='logContact']") # getElement(:css, "input[name='logContact']").attribute("value")
  end

  def getNotesInForm()
    return getTextFromInput(:css, "textarea[name='Note']") #getElement(:css, "textarea[name='Note']").attribute("value")
  end

  def getContactTypeInForm()
    return getTextFromInput(:css, "select[name='logActivity']") #getElement(:css, "select[name='logActivity']").attribute("value")
  end

  def getNthDateInCommList(rowIndex)
    return getCellTextByRowIndex(rowIndex, DATE_COLUMN_ID)
  end

  def getNthTypeInCommList(number)  #".list-table li"
    return getCellTextByRowIndex(rowIndex, COMMUNICATION_TYPE_COLUMN_ID)
  end

  def getNthSubjectInCommList(rowIndex)
    return getCellTextByRowIndex(rowIndex, SUBJECT_COLUMN_ID)
  end

  def getNthWhoInCommList(rowIndex)
    return getCellTextByRowIndex(rowIndex, CONTACT_COLUMN_ID)
  end

  def getMessageInEventDetail()
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end

  def getMessageInEventDetailAriaLabel()
    return getElement(:css, "div[ng-if='!details'] span").attribute("aria-label")
  end
  
  def getSelectedLogSubject()
    return getTextFromInput(:css, "input[name='logTask']")
  end
  
  def getCellText(rowEntry, colId)
      cellElem = rowEntry.find_elements(:css, CELL_CLASS)[colId] 
      puts"cellElem[#{colName}] is nil" if cellElem == nil
      return cellElem.text.strip      
  end
  
  def getCellTextByRowIndex(rowIndex, colName)
    rowEntry = getCommunicationsLogEntry(rowIndex)
    return getCellText(rowEntry, colName)    
  end
    
  def getSubjectTextInRowEntry(rowEntry)
    return getCellText(rowEntry, SUBJECT_COLUMN_ID)
  end
    
  def getDateTextInRowEntry(rowEntry)
    return getCellText(rowEntry, DATE_COLUMN_ID)
  end
    
  def getContactTextInRowEntry(rowEntry)
    return getCellText(rowEntry, CONTACT_COLUMN_ID)
  end
    
  def getCommunicationTypeTextInRowEntry(rowEntry)
    return getCellText(rowEntry, COMMUNICATION_TYPE_COLUMN_ID)
  end

  
  def getCommunicationsLogEntry(i)  # i is base 1
    begin      
      
      elements = getElements(:css, ".list-table li") # WORKS TOO: "li[role='button']") 
      return elements[i-1]
    rescue Exception=>e
      puts "Exception " + e.to_s
      return nil
    end
  end
  
  
  def getCommunicationsLogCount()
    begin      
      
      elements = getElements(:css, ".list-table li") 
      return elements.length
    rescue Exception=>e
      puts "Exception " + e.to_s
      return 0
    end
  end

  def findIndexWithGivenLogSubject(commSubjectText)
    commLogLength = getCommunicationsLogCount()
    #puts "communications Log Length : " + commLogLength.to_s
    index = -1

    for i in 1..commLogLength
      entry = getCommunicationsLogEntry(i)
      subjectText = getSubjectTextInRowEntry(entry)
      #puts("#{i}:[#{subjectText}]")
      if subjectText == commSubjectText then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    puts "Can not find entry with subject =[#{commSubjectText}]" if index == -1
    return index
  end
  
  def isCommLogDisplayed?(commSubject)
    isDisplaying = false
    rowIndex = findIndexWithGivenLogSubject(commSubject)
    if(rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end

  def setNarrative(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, "div.no-results-message")
    #return getTextForElement(:css, '.no-results-message')
  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrative(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest

  end

  def getContactTypeDefaultText
    #return getTextForElement(:css, "option[ng-if='!ngModel || showNull']")
    select = Selenium::WebDriver::Support::Select.new(@driver.find_element(:css,  "select[name='logActivity']"))
    option = select.first_selected_option
    return option.text
  end
  
  def fillDataInCommunicationLogForm(dateStr, type, subject, who, note)
    
    #JRNL-2728: Verify that the default option is null with text "Select" displays
    #getContactTypeDefaultText.should == "Select"
    setDate(dateStr, "input[name='date']")
    selectType(type)
    setSubject(subject)
    setWho(who)
    setNote(note)
    
  end

  def addCommunicationLog(dateStr, type, subject, who, note)
    clickAddCommunicationBtn()
    !45.times{ break if (getPrimaryHeader() == ADD_LOG_ENTRY_TITLE); sleep 1 }
    getPrimaryHeader().should == ADD_LOG_ENTRY_TITLE

    sleep 1
    fillDataInCommunicationLogForm(dateStr, type, subject, who, note)
    clickSaveButton()
  end

  def EditCommunicationLog(type, subject, who)
    selectType(type)
    setSubject(subject)
    setWho(who)
    clickSaveButton()
  end
  
#"%Y-%m-%d"
  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo

  end

end