require 'rubygems'
require 'selenium-webdriver'

require_relative  "../pages/login_screen"
require_relative  "../pages/roa"
require_relative  "../pages/eula"
require_relative  "../pages/main"
require_relative  "../pages/menu"
require_relative  "../pages/nav_menu"
require_relative  "../pages/landing_screen"
require_relative  "../module/DriverUtility"
require_relative  "../pages/notifications"
require_relative  "../pages/modal_popup"
require_relative  "../pages/reminders"

class Common
  include DriverUtility

  def initialize(driver)
    @driver = driver
    @loginpage = Login_Screen.new(@driver)
    @eula = Eula.new(@driver)
    @pleasenote = PleaseNote.new(@driver)
    @roa = Roa.new(@driver)
    @landing = Landing_screen.new(@driver)
    @main = Main.new(@driver)
    @menu = Menu.new(@driver)
    @nav_menu = Nav_menu.new(@driver)
    @notification = Notifications_Reminders.new(@driver)
    @modal = Modal_popup.new(@driver)
    @reminders = Reminders.new(@driver)
  end

  def loginEndsOnLandingPage(loginId, userNameOnFooter)

    !15.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !15.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    @loginpage.passingByTheLandingPage()

    !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran(loginId)

####################################################################################################################
####################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###############################
####################################################################################################################
####################################################################################################################

    #waitForPageToFinishLoading
      sleep 3
    if is_element_present(:css, "input[id='no-show-notice']") then
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept
    end

####################################################################################################################
####################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###############################
####################################################################################################################
####################################################################################################################

    !15.times{ break if (@main.getFooterText() == "Logged in as " + userNameOnFooter); sleep 1 }
      if @main.getNotificationText == "Notification Settings"
        byPassTheNotificationSettingsScreen
      else
        puts 'Notification Settings page did not exits'
      end

    waitForPageToFinishLoading
    if isElementVisible(:id, 'waitingRoomButton')
      click(:id, 'waitingRoomButton')
    end

##############################################################################################################################
##############################################################################################################################
# TAKE A TOUR IS SHOWING TWO TIMES WHICH IS CAUSING AUTOMATION TO REFRESH TO WORK THIS IS A BUG ONCE FIXED REMOVE BELOW CODE #
##############################################################################################################################
##############################################################################################################################

    refreshBrowser

###############################################################################################################################
###############################################################################################################################
# TAKE A TOUR IS SHOWING TWO TIMES WHICH IS CAUSING AUTOMATION TO REFRESH TO WORK THIS IS A BUG ONCE FIXED REMOVE ABOVE CODE ##
###############################################################################################################################
###############################################################################################################################

    sleep 5
  end

  def fastLoginEndsOnLandingPage(loginId, firstName, lastName, uniqueId)
    !15.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !15.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }

    @loginpage.passingByTheLandingPage()

    !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginSkipROAAndInitialSettings(loginId, firstName, lastName, uniqueId)

    !15.times{ break if (@main.getFooterText() == "Logged in as " + lastName + ", " + firstName); sleep 1 }

  end

  def switchUserThenLogBackInAndGoToLeftSideNav(loginId, userNameOnFooter)
    @main.clickUserMenu()
    !15.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    @menu.clickLogoutBtn()
    ###BUG
    ###switch_to_alert_accept
    ###
    !15.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }

    #For Demo
    ####################################DEMO#######################################################
    sleep(5)
    @driver.execute_script("$('a[href=\"/my-va-health\"]')[0].scrollIntoView(true)")
    click(:css, 'a[href="/my-va-health"')
    !15.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }

    waitForPageToFinishLoading
    if @eula.acceptEulaVisible?
      @eula.clickAccept()
    end

    @loginpage.passingByTheLandingPage()

    !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran(loginId)

    if is_element_present(:css, "input[id='no-show-notice']") then
    waitForPageToFinishLoading
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept
    else
    waitForPageToFinishLoading
    end

    ####################################DEMO#######################################################

    # @loginpage.passingByTheLandingPage()
    # !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    # @loginpage.loginAsVeteran(loginId)

    !15.times{ break if (@main.getFooterText() == "Logged in as " + userNameOnFooter); sleep 1 }

    waitForPageToFinishLoading
    if isElementVisible(:id, 'waitingRoomButton')
      click(:id, 'waitingRoomButton')
    end

    waitForPageToFinishLoading
    @main.clickNavMenu()
    !15.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
  end

  def fastSwitchUserThenLogBackInAndGoToLeftSideNav(loginId, firstName, lastName, uniqueId)
    @main.clickUserMenu()
    !15.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    @menu.clickLogoutBtn()
    !15.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    gotoHome(BASE_URL)
    @loginpage.passingByTheLandingPage()
    !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginSkipROAAndInitialSettings(loginId, firstName, lastName, uniqueId)
    !15.times{ break if (@main.getFooterText() == "Logged in as " + lastName + ", " + firstName); sleep 1 }
    @main.clickNavMenu()
    !15.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
  end

  def verifyRequiredFieldTextIsDisplayed()
    return getTextForElement(:css, "span[ng-if*='requiredExists()']")
  end
        
  def getDefaultMsg()
    return getTextForElement(:css, "div.page.row span")
  end


  def navigateToNotificationSettingAndSetOrRemoveEmail(email)
    #Navigate to the Notification Setting screen to remove the email address
    @main.clickNavMenu
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='Notifications']").click
    waitForPageToFinishLoading

    #Click the Gear icon
    @notification.clickTheGearIcon()
    !15.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    sleep 2
    #Remove or Add email address
    @landing.setEmailAddress(email)
    sleep 2
    #Click Save
    @modal.clickSaveButton()
    sleep 3
  end
  
  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo
  end

  def clickAddButton
    click(:css, "button[ng-click='getDetails()']")
  end

  def getAddButtonAltText()
    element = getElement(:css, "button[ng-click='getDetails()']")
    altText = element.attribute("title")
    return altText
  end

  def getBackButtonAltText()
    element = getElement(:css, "button[ng-click='goBack()']")
    altText = element.attribute("title")
    return altText
  end

  def isAddButtonVisible()
    return isElementVisible(:css, "button[title='Add']")
  end

  def isBackButtonVisible()
    return isElementVisible(:css, "button[ng-click='goBack()']")
  end

  def clickSaveButton()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickCancelButton()
    click(:css, 'button[ng-click="cancel()"]')
    sleep 0.5
  end

  def clickDeleteButton()
    click(:css, "button[ng-click='delete()']")
  end

  def clickBackButton()
    click(:css, "button[ng-click='goBack()']")
  end

  def isTheFilterButtonVisible()
    return @driver.find_element(:css, "button[ng-click='filter()']").displayed?
  end

  def isTheResetButtonVisible()
    return @driver.find_element(:css, "button[ng-click='reset()']").displayed?
  end

  def clickFilter
    click(:css, "button[ng-click='filter()']")
    sleep 2
  end

  def clickReset
    click(:css, "button[ng-click='reset()']")
    sleep 2
  end

  def showOrHideFilter()
    click(:css, "i.pull-left")
    sleep 2
  end

  def selectRadioButton(name, value)
    click(:css, "input[name='" + name + "'][value='" + value + "']")
  end

  def clearLocalStorage()
    @driver.execute_script('window.localStorage.clear()')
  end





  def glucoseDropdown
    dropdown = @driver.find_element(:xpath, "//select[@name='Tested']")
    select_list = Selenium::WebDriver::Support::Select.new(dropdown)
    select_list.select_by(:text, 'Fasting (8 hours)')

    selected_option = select_list.selected_options[0].text
    expected(selected_option).to eql 'Fasting (8 hours)'
  end








end