require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Attachment
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def addFileInputName
    return "addFile"
  end

  def addAttachmentButton
    return "button[name='addAttachment']"
  end

  def attachmentLabel
    return ".attachments-wrapper h5"
  end

  def nthViewAttachmentButton(n)
    return ".attachments tr:nth-of-type(" + (n + 1).to_s + ") a"
  end

  def nthDeleteAttachmentButton(n)
    return ".attachments tr:nth-of-type(" + (n + 1).to_s + ") button"
  end

end