require 'rubygems'
require 'jquery'
require 'selenium-webdriver'
require "json"

require_relative  "../module/DriverUtility"

class Assessment_Questionnaire
  include DriverUtility

  INPUT_TEXT_LABEL = "span.input-label-content"
  RADIO_OPTIONS_LABEL = "span.input-group-radio-legend"
  SAVE_DRAFT_BUTTON = "button[ng-click='saveDraft()']"
  EXIT_BUTTON_FOR_PHONE = "button[title='Return to Assessment List options']"

  def initialize(driver)
     @driver = driver
     #@base_url = baseUrl
     #sleep 1.5
  end
  
  def getQuestionNumText()
    return getTextForElement(:css, "div.primary-content div:nth-of-type(2) div:nth-of-type(1) div:nth-of-type(1) h5 span")
  end

  def getQuestionLabel(textOrRadio, numQuestion)
    if(textOrRadio == 'radio')
      getTextForElement(:css, "input-group-radio[name='Q" + numQuestion.to_s + "'] span.input-group-radio-legend")
    else
      getTextForElement(:css,  "input-text[name='Q" + numQuestion.to_s + "'] span.input-label-content")
    end
  end

  def clickBackButton()
    #click(:css, "form[name='assessmentForm'] button:nth-of-type(3)")
    click(:css, "button[class='btn btn-primary form-button questionnaire-back']")
  end

  def isAnyRadioButtonChecked(questNum)

    buttonChecked = getElements(:css, "form[name='assessmentForm'] > div:nth-of-type(" + questNum.to_s + ")  input[type='radio']");

    anyRadioOptionChecked = false

     for i in 0..(buttonChecked.length - 1)
        if(buttonChecked[i].selected?)
          puts "!!!! checked? " + i.to_s

          anyRadioOptionChecked = true
          break
        end
     end

     return anyRadioOptionChecked;

  end

  def isTheSaveDraftButtonDisabled()
    element = getElement(:css, SAVE_DRAFT_BUTTON)
    if element.attribute("disabled") ==  true then
      buttonDisabled = true
    else
      buttonDisabled = false
    end

    return buttonDisabled
  end
  
  def isTheNextButtonDisabled()
    element = getElement(:css, "button[ng-click='navAction(\"NEXT\")']")
    if element.attribute("disabled") ==  true then
      buttonDisabled = true
    else 
      buttonDisabled = false
    end
    
    return buttonDisabled
  end
  
  def clickTheNextButton()
    click(:css, "button[ng-click='navAction(\"NEXT\")']")
    sleep 2
  end
  
  def clickTheSubmitButton()
    click(:css, "button[ng-click='navAction(\"NEXT\")']")
  end
  
  def clickTheSaveButton()
    click(:css, SAVE_DRAFT_BUTTON)
  end
  
  def selectOneRadioButton(whichQuestion, whatValue)
    click(:css, "input[name='" + whichQuestion + "'][type='radio'][value='" + whatValue +"']")
    #click(:css, "input[name='Q1'][type='radio'][value='Sometimes']")
  end

  def retrieveTheValueOfTheRadioButton(whichOne)
    element = getElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(1) div:nth-of-type(" + whichOne.to_s + ") input")
    if element.attribute("checked") ==  true then
      return getTextForElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(2) div:nth-of-type(" + whichOne.to_s + ") input")
    else
      puts "This radio button was not selected"
      return false
    end

  end
  
  def verifyThisQuesitonIsNotAnswered()
    verifyThisQuesitonIsNotAnswered = true
    radioButtonListLength = getElements(:css, "form[name='assessmentForm'] fieldset:nth-of-type(1) div").length
    #puts "radioButtonListLength=" + radioButtonListLength.to_s
    for i in 1..radioButtonListLength-1
      element = getElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(1) div:nth-of-type(" + i.to_s + ") input")
      
      if element.attribute("checked") != nil then
        verifyThisQuesitonIsNotAnswered = false
        puts "Answer to the question is saved even without explicit clicking the Save button"
        break
      end
      
    end
    
    return verifyThisQuesitonIsNotAnswered
  end
  
  def verifyRadioButtonCheckedNextButtonActivated(questNum)
    radioButtonChecked = isAnyRadioButtonChecked(questNum)
    nextButtonDisabled = isTheNextButtonDisabled()
    
    if radioButtonChecked != "" || nextButtonDisabled == false then
      return true
    else
      return false
    end
    
  end
  
  def verifyRadioButtonNotCheckedNextButtonDisabled(questNum)
    radioButtonChecked = isAnyRadioButtonChecked(questNum)
    nextButtonDisabled = isTheNextButtonDisabled()
    
    if radioButtonChecked == "" || nextButtonDisabled == true then
      return true
    else
      return false
    end  
  end
  
  def verifyTheSubmitButtonIsDisabled()
    buttonDisabled = false
    element = getElement(:css, "form[name='assessmentForm'] button:nth-of-type(4)")
    if element.attribute("disabled") != nil then
      buttonDisabled = true
    end
    
    return buttonDisabled

  end
  
  def getTheDisplayedButtonName()
    return getTextForElement(:css, "button[ng-click='navAction(\"NEXT\")']")
    
  end
  
  def typeInFeaturesAtWhichQuestion(questNum, whatStr)
    #form/fieldset[2]/div/input
    #form/fieldset[2]/div/textarea
    @driver.find_element(:css, "input-text[name='Q" + questNum.to_s + "'] div label div textarea").send_keys(whatStr)
  end
  
  def verifyThisEditBoxQuestionIsAnswered(questNum)
    newquestNum = questNum
    return getTextForElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(" + newquestNum.to_s + ") div textarea")
  end
  
  def deleteAnswerAtWhichQuestion(questNum)
    @driver.find_element(:css, "input-text[name='Q" + questNum.to_s + "'] div label div textarea").clear()
  end 
  
  def verifyTheTotalNumOfCharactersAreDisplayed(whatNum)
    displayedSumCorrectly = true
    displayedText = getTextForElement(:css, "input-text[name='Q1'] div label div span:nth-of-type(1)")
    #puts "displayedText =" + displayedText
    sumArry = displayedText.split(" of ")
    #puts "sumArry[0], length=" + sumArry[0] + " " + sumArry[0].length().to_s
    #puts "whatNum, length=" + whatNum.to_s + " " + whatNum.to_s.length().to_s
    if whatNum != sumArry[0].strip.to_i then
      puts "Total number of characters should be: " + whatNum.to_s
      puts "But the displayed sum is: " + sumArry[0]
      displayedSumCorrectly = false
    end
    
    return displayedSumCorrectly
  end
  
  def enterTheScaleAtRangeQuestion(whichQuestion, numStr)
    #form/fieldset[3]/div/input
    #@driver.execute_script( jQuery('input[name=Q10]').val(4).trigger('tap'))
    #@driver.execute_script( jQuery('input[type=range]').trigger('click'))
#    @driver.find_element(:name, "'" + whichQuestion + "'").send_keys numStr
#    @driver.find_element(:name, "'" + whichQuestion + "'").send_keys :arrow_left
    click(:css, "input[name=" + whichQuestion + "]")
    @driver.find_element(:css, "input[name=" + whichQuestion + "]").send_keys :arrow_right
  end
  
  
  def checkOneOrMultiCheckBox(questNum, whichBoxArry)
    arryLength = whichBoxArry.length()
    puts "arryLength=" + arryLength.to_s
    for i in 0..arryLength-1
      whichBox = whichBoxArry[i]
      #puts "whichBox=" + whichBox.to_s
      #form/fieldset[5]/div[1]
      click(:css, "form[name='assessmentForm'] div:nth-of-type(" + questNum.to_s + ") div:nth-of-type(" + whichBox.to_s + ") input")
    end
    
  end

  def getSliderBarSettledValue()
    element = getElement(:name, "Q2")
    return element.attribute("aria-valuetext")
  end
  
  def isAValueSettledForSliderBar()
    value = getSliderBarSettledValue()
    puts "value=" + value
    if value.strip != "" then
      return true
    else
      return false
    end
  end
  
end