require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Assessment_List
  include DriverUtility
  def initialize(driver)
    @driver = driver
    #@base_url = baseUrl
    #sleep 1.5
  end

  def getAssessmentName(number)
    puts getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def getAssessmentTitleFromSeconaryScreen()
     return getTextForElement(:css, "div.secondary-content div h2")

  end

  def getDetailDefaultText()
    return getTextForElement(:css,  "span.placeholder-message")
  end
    
  def clickThisAssessment(number)
    click(:css, "div.secondary-content ul li:nth-of-type(" + number.to_s + ") button")
  end

  def verifyAssessmentSortedByNameAlphbetically()
    isAlphabeticOrder = true
    hassListLength = getElements(:css, "ul.secondary-list li").length
    #puts "hassListLength=" + hassListLength.to_s
    rowCount = 0

    previousHass = getTextForElement(:css, "ul.secondary-list li:nth-of-type(1) button")
    for i in 1..hassListLength

      if(rowCount === 0)
        previousMed = getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + i.to_s + ") button")
      end
      nextMed = getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + i.to_s + ") button")
      #           puts "previousMed=" + previousMed
      #           puts "nextMed=" + nextMed
      #           puts "i=" + i.to_s
      #           puts previousMed <=> nextMed

      if previousMed.downcase > nextMed.downcase #covert the strings to lower case, since it's case insensitive
        isAlphabeticOrder = false
        #             puts "isAlphabeticOrder is false. Status =" + medStatus
        #             puts "previousMed=" + previousMed
        #             puts "preMedLength=" + previousMed.length.to_s
        #             puts "nextMed=" + nextMed
        #             puts "nextMedLength=" + nextMed.length.to_s
        #             puts "enter the false loop"
        #             puts "i=" + i.to_s
        #             puts previousMed <=> nextMed
        return isAlphabeticOrder
        break
      end

      previousMed = nextMed
      rowCount += 1

    end

    return isAlphabeticOrder
  end

  def findIndexWithGivenName(hassName)
    #"ul[class='secondary-list'] li:nth-of-type(" + number.to_s + ") button"
    hassListLength = getElements(:css, "div.secondary-content ul li").length
    
    for i in 1..hassListLength
      name = getTextForElement(:css, "div.secondary-content ul li:nth-of-type(" + i.to_s + ") button span.btn-txt")
      
      if hassName == name then
        return i
      end

    end
  end
  
  def isThisAssessmentOnTheList(hassName)
    assessmentFound = false
    hassListLength = getElements(:css, "div.secondary-content ul li").length
    for i in 1..hassListLength
      name = getTextForElement(:css, "div.secondary-content ul li:nth-of-type(" + i.to_s + ") button")
      if hassName == name then
        puts "Verify that the Assessment (" + hassName +") is on the Assessment List"
        assessmentFound = true
        return assessmentFound
      end
    end
    
    return assessmentFound
    
  end

  def getNthAssessmentFeatureName(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button span")
  end
  
end