require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Assessment_Information
  include DriverUtility

  START_ASSESSMENT_BTN = "button[ng-click='startAssessment()']"

  def initialize(driver)
     @driver = driver
     #@base_url = baseUrl
     #sleep 1.5
  end

  def isStartAssessmentButtonAvailable()
    return @driver.find_element(:css, "button[ng-click='startAssessment()']").displayed?
  end
  
  def getAssessmentNameFromInfoPageHeader()
     return getTextForElement(:css, "div.primary-content .page h4")

  end

  def getInstructionalText()
    return getTextForElement(:css,  "div.primary-content div.page div.pre-style")
  end
  
  def getAssessmentTitleFromPrimaryScreen()
     return getTextForElement(:css, "div.primary-content h2")

  end
  
  def getDefaultDisplayFromDetailPage()
     return getTextForElement(:css, "div.primary-content div:nth-of-type(2) span")

  end
    
  def getAssessmentNameFromQuestionPageHeader()
     return getTextForElement(:css, "div.primary-content .page h4:nth-of-type(1)")

  end
  
  def isAssessmentBulletContentAvailable()
     displayedText = getTextForElement(:css, "div.pre-style")
     bulletText1 = "This assessment measures current Caregiver status"
     bulletText2 = "Each Caregiver is asked to complete this assessment at least at the beginning and end of the pilot. The assessment may be taken more often"
     bulletText3 = "Caregivers should use their personal log in"
     bulletText4 = "Tapping next will start the assessment and indicates agreement with the following consent form. Please read the consent form below"
         
     if displayedText.include?(bulletText1) then
       if displayedText.include?(bulletText2) then
         if displayedText.include?(bulletText3) then
           if displayedText.include?(bulletText4) then
             puts "Verified that the bullet contents are displayed in the assessment"
             return true
           else
             return false
           end
         else
           return false
         end
       else
         return false 
       end
     else
       return false
     end
  end
  
  def isBulletContentAvailableForFeedbackAssessment()
     displayedText = getTextForElement(:css, "div.pre-style")
     bulletText1 = "Help improve VA Mobile Apps"
     bulletText2 = "Provide comments about specific application features"
       
     if displayedText.include?(bulletText1) then
       if displayedText.include?(bulletText2) then
         puts "Verified that the bullet contents are displayed in the Feedback assessment"
         return true
       else
         return false 
       end
     else
       return false
     end
  end
  
  def isTopPortionOfOptionalContentDisplayed()
    displayedText = getTextForElement(:css, "div.pre-style")
    topOptionalContentText = "Purpose of study and how long it will last: You are invited to volunteer for a research study. You are asked to take part because you are a caregiver for a Veteran. This research is to help the VA assess the effectiveness of its Clinic-in-Hand mobile health technology pilot program. There will be up to 1,000 caregivers participating in this study. You will be asked to complete short surveys on three different days. The first will take approximately 20 minutes and will consist of questions about you as well as your experience with caregiving. You can do it today with me over the phone or you can do it later using the Pop-Up app on your iPad or another time on the phone. The second will be in about 6 months and the third will be in about 12 months. The second and third follow-up surveys will each take about 10 minutes and will ask you to answer questions about your caregiving experience"
    if displayedText.include?(topOptionalContentText) then
      puts "Verified that the top portion of the Optional Text is displayed in the assessment"
      return true
    else
      return false
    end
  end
  
  def isBottomPortionOfOptionalContentDisplayed()
    displayedText = getTextForElement(:css, "div.pre-style")
    bottomOptionalContentText = "I understand my rights as a research subject, and I voluntarily consent to participate in this study. I understand what the study is about and how and why it is being done"
    if displayedText.include?(bottomOptionalContentText) then
      puts "Verified that the top portion of the Optional Text is displayed in the assessment"
      return true
    else
      return false
    end
  end
  
  def clickStartAssessmentButton()
    click(:css, START_ASSESSMENT_BTN)
  end
  
end