require 'rubygems'
require 'selenium-webdriver'

require_relative "../../module/DriverUtility"
require_relative "../date_picker"


class Vitals < EntryForm
  include DriverUtility


  TITLE = ".main-title[aria-hidden]"
  EVENT_TITLE = "eventTitle"
  VITALS_BTN = "Vitals"
  SECONDARY_HEADER = ".secondary-header h2"
  PRIMARY_HEADER = ".primary-header h2"
  NOTE = "Note"
  BLOOD_PRESSURE_BTN = 'ul.secondary-list > li:nth-of-type(1) > button'
  RESPIRATION_BTN = 'ul.secondary-list > li:nth-of-type(2) > button'
  TEMP_BTN = 'ul.secondary-list > li:nth-of-type(3) button'
  HEIGHT_BTN = 'ul.secondary-list > li:nth-of-type(4) button'
  WEIGHT_BTN = 'ul.secondary-list > li:nth-of-type(5) button'
  PDF_BTN = 'button[ng-click="fetchVitalsAsPdf()"]'

  def initialize(driver)
    @driver = driver
    @date_filter = Date_Filter.new(@driver)

  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def getMessageInDetail()
    return getTextForElement(:css, ".no-results-message")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, SECONDARY_HEADER)
  end

  def getPrimaryHeader()
    return getTextForElement(:css, PRIMARY_HEADER)
  end

  def getVitalsBackgroundImageFileName()
    return getElement(:css, '.primary-content .intro').style('background-image')
  end

  def getListLabels
    listLabels = []
    listLength = getElements(:css, "div.secondary-content ul li").length

    for i in 1..listLength
      listLabels[i] = getTextForElement(:css, "div.secondary-content ul li:nth-of-type(" + i.to_s + ") button span.ng-binding")
    end

    return listLabels

  end

  def hasListBtn(label)
    # puts getListLabels()
    indexNum = getListLabels().index(label)
    return indexNum.is_a?Integer
  end

  def getTotalCount()
    begin
      elements = getElements(:css, "tr[ng-repeat]")
      return elements.length
    rescue Exception => e
      puts "Exception " + e.to_s
      return 0
    end
  end

  def getVitalIntroText()
    return getTextForElement(:css, '.primary-content .intro p')
  end

  def getNthSystolicInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(1)")
  end

  def getNthDiastolicInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(2)")
  end

  def getNthPulseInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(3)")
  end

  def getNthPositionInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(4)")
  end

  def getNthDateInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(5)")
  end

  def getNthTimeInBPList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(6)")
  end

  def getNthRespHeightWeightInList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(1)")
  end

  def getNthDateInRespHeightWeightList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(2)")
  end

  def getNthTimeInRespHeightWeightList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(3)")
  end

  def getNthTempInList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(1)")
  end

  def getNthTypeInTempList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(2)")
  end

  def getNthDateInTempList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(3)")
  end

  def getNthTimeInTempList(number)
    return getTextForElement(:css, "tbody tr.ng-scope:nth-of-type(" + number.to_s + ") td:nth-of-type(4)")
  end

  def getNthLabel(number)
    return getTextForElement(:css, "th[ng-repeat]:nth-of-type(" + number.to_s + ")")
  end

  def getNthLabelSystolic()
    return getTextForElement(:css, "input-number[name=Systolic] div label span span:nth-of-type(2)")
  end

  def getNthLabelDiastolic()
    return getTextForElement(:css, "input-number[name=Diastolic] div label span span:nth-of-type(2)")
  end

  def getNthLabelPulse()
    return getTextForElement(:css, "input-number[name=Pulse] div label span span:nth-of-type(2)")
  end

  def getNthLabelRespiration()
    return getTextForElement(:css, "input-number[name=Respiration] div label span span:nth-of-type(2)")
  end

  def getNthLabelHeight()
    return getTextForElement(:css, "input-number[name=Height] div label span span:nth-of-type(2)")
  end

  def getNthLabelWeight()
    return getTextForElement(:css, "input-number[name=Weight] div label span span:nth-of-type(2)")
  end

  def getNthLabelTemp()
    return getTextForElement(:css, "input-number[name=Temperature] div label span span:nth-of-type(2)")
  end

  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo

  end

  def getPlaceHolder(name)
    puts "IS THIS METHOD BEING CALLED"
    element = getElement(:name, name)
    return element.attribute('placeholder')
  end


  def findIndexWithAGivenPosition(position)
    bpLength = getTotalCount()
    index = -1

    for i in 1..bpLength
      #puts "listtype = " + getNthTypeInMealList(i)
      listtype = getNthPositionInBPList(i)
      if listtype == position then
        index = i
        break
      end
    end
    puts "rowIndex found : " + index.to_s
    return index
  end

  def findIndexWithAGivenType(type)
    tempLength = getTotalCount()
    index = -1

    for i in 1..tempLength
      listtype = getNthTypeInTempList(i)
      if listtype == type then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    return index
  end

  def findIndexWithAGivenTime(timeStr)
    respirationLength = getTotalCount()
    index = -1

    for i in 1..respirationLength
      #puts "listtype = " + getNthTypeInMealList(i)
      listtype = getNthTimeInRespHeightWeightList(i)
      if listtype == timeStr then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    return index
  end


  def isThisButtonVisible(buttonCSS)
    begin
      element = @driver.find_element(:css, buttonCSS)
      return element.displayed?
    rescue Exception => e
      return false
    end
  end

  def setSystolic(number)
    systolicbp =@driver.find_element(:css, "input[name='Systolic']")
    systolicbp.clear
    systolicbp.send_keys(number)
  end

  def setDiastolic(number)
    diastolicbp = @driver.find_element(:css, "input[name='Diastolic']")
    diastolicbp.clear
    diastolicbp.send_keys(number)
  end

  def setPulse(number)
    pulse = @driver.find_element(:css, "input[name='Pulse']")
    pulse.clear
    pulse.send_keys(number)
  end

  def selectPosition(position)
    select = getElement(:css, "select[name='Position']")
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if (option.attribute('value') == position)
        option.click
        break
      end
    end
  end

  def selectType(type)
    select = getElement(:css, "select[name='Type']")
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if(option.attribute('value') == type)
        option.click
        break
      end
    end
  end

  def setHeight(number)
    respiration = getElement(:css, "input[name='Height']")
    respiration.clear
    respiration.send_keys(number)
  end

  def setWeight(number)
    respiration = getElement(:css, "input[name='Weight']")
    respiration.clear
    respiration.send_keys(number)
  end

  def setTemp(number)
    respiration = getElement(:css, "input[name='Temperature']")
    respiration.clear
    respiration.send_keys(number)
  end

  def setRespiration(number)
    respiration = getElement(:css, "input[name='Respiration']")
    respiration.clear
    respiration.send_keys(number)
  end

  def setTempType(tempType)
    select = getElement(:css, "select[name='Type']")
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if option.attribute('value') == tempType
        option.click
        break
      end
    end
  end

  def setNote(text)
    note = @driver.find_element(:css, "textarea[name='" + NOTE + "']")
    note.clear
    note.send_keys(text)
  end

  def setDateRange(fromDate, toDate)
    @date_filter.setDateRangeAndFilter(fromDate, toDate)
    sleep 5
  end

  def addBP(dateStr, timeStr, systolic, diastolic, pulse, position, note)
    clickAddBtn()

    !45.times{ break if (getPrimaryHeader() == "Enter Blood Pressure"); sleep 1 }

    setDate(dateStr, "input[name='date']")
    sleep 1
    setTime(timeStr, "input[name='time']")
    sleep 0.5
    setSystolic(systolic)
    sleep 0.2
    setDiastolic(diastolic)
    sleep 0.2
    setPulse(pulse)
    sleep 0.2
    selectPosition(position)
    sleep 0.2
    setNote(note)
    0.2

    clickSaveNewBtn()
  end

  def addRespiration(dateStr, timeStr, respiration, note)
    clickAddBtn()

    !45.times{ break if (getPrimaryHeader() == "Enter Respiration"); sleep 1 }

    setDate(dateStr, "input[name='date']")
    sleep 1
    setTime(timeStr, "input[name='time']")
    sleep 0.5
    setRespiration(respiration)
    sleep 0.2
    setNote(note)
    sleep 0.2

    clickSaveNewBtn()
  end

  def addTemp(dateStr, timeStr, temperature, type, note)
    clickAddBtn

    !45.times{ break if (getPrimaryHeader() == "Enter Temperature"); sleep 1 }

    setDate(dateStr, "input[name='date']")
    sleep 1
    setTime(timeStr, "input[name='time']")
    sleep 0.5
    setTemp(temperature)
    sleep 0.2
    setTempType(type)
    sleep 0.2
    setNote(note)
    sleep 0.2

    clickSaveNewBtn
  end

  def addHeight(dateStr, timeStr, height, note)
    clickAddBtn()

    !45.times{ break if (getPrimaryHeader() == "Enter Height"); sleep 1 }
    0.2
    setDate(dateStr, "input[name='date']")
    sleep 1
    setTime(timeStr, "input[name='time']")
    sleep 0.5
    setHeight(height)
    sleep 0.2
    setNote(note)

    clickSaveNewBtn
  end

  def addWeight(dateStr, timeStr, weight, note)
    clickAddBtn()

    !45.times{ break if (getPrimaryHeader() == "Enter Weight"); sleep 1 }

    setDate(dateStr, "input[name='date']")
    sleep 1
    setTime(timeStr, "input[name='time']")
    sleep 0.5
    setWeight(weight)
    sleep 0.2
    setNote(note)
    sleep 0.2

    clickSaveNewBtn()
  end

  def clickVitals()
    click(:id, VITALS_BTN)
  end

  def clickThisButton(buttonCSS)
    click(:css, buttonCSS)
  end

  def clickAddBtn()
    click(:css, "button[ng-click='getDetails()']")
  end

  def clickCancelBtn()
    click(:css, "button[ng-click='cancel()']")
  end

  def clickDeleteBtn()
    click(:css, "button[ng-click='deleteVitals()']")
  end

  def clickSaveNewBtn()
    click(:css, "button[ng-click='saveVitals(details.isNew)']")
  end

  def clickNthVital(number)
    click(:css, "tr[ng-repeat]:nth-of-type(" + number.to_s + ")")
  end

  def clickFilterBtn()
    click(:css, "ul.nav.nav-pills.ng-scope li:nth-of-type(1) button")
  end

  def click_bp_btn
    click(:css, BLOOD_PRESSURE_BTN)
  end

  def click_resp_btn
    click(:css, RESPIRATION_BTN)
  end

  def click_temp_btn
    click(:css, TEMP_BTN)
  end

  def click_height_btn
    click(:css, HEIGHT_BTN)
  end

  def click_weight_btn
    click(:css, WEIGHT_BTN)
  end

  def clickPDFBtn
    click(:css, PDF_BTN)
  end

  def verifyTotalCharacterInNote()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNote(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest
  end

  def verifyDefaultDateRangeIs30DaysBack()
    verifiedYes = false
    todayDate = getDateNthDaysAgo(0, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    fromDate = getTextFromInput(:css, "input[name='startDate']")

    toDate = getTextFromInput(:css, "input[name='endDate']")
    if toDate == todayDate and fromDate == thirtyDaysAgo then
      verifiedYes = true
    end
  end

  def editABP(number)
    setDiastolic(number)
    clickSaveNewBtn()
  end

  def editARespiration(number)
    setRespiration(number)
    clickSaveNewBtn()
  end

  def editAHeight(number)
    setHeight(number)
    clickSaveNewBtn()
  end

  def editAWeight(number)
    setWeight(number)
    clickSaveNewBtn()
  end

  def editATemp(number)
    setTemp(number)
    clickSaveNewBtn()
  end

  def isThisBPDisplayed?(position)
    isDisplaying = false
    rowIndex = findIndexWithAGivenPosition(position)
    if (rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end

  def isThisTempDisplayed?(type)
    isDisplaying = false
    rowIndex = findIndexWithAGivenType(type)
    if(rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end

  def isPDFButtonDisplayed?()
    return isElementVisible(:css, 'button[ng-click="fetchVitalsAsPdf()"]')
  end


  def isThisRecordDisplayed?(time)
    isDisplaying = false
    rowIndex = findIndexWithAGivenTime(time)
    if (rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end


  def isBPDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDateWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    bpCount = getTotalCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..bpCount
      bpDate = getNthDateInBPList(i)
      bpDateObj = DateTime.strptime(bpDate, "%m/%d/%Y")

      #puts "mealDate " + mealDate
      if bpDateObj <= fromDateObj and bpDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def isTempDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    puts "[isDateWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    tempCount = getTotalCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..tempCount
      tempDate = getNthDateInTempList(i)
      tempDateObj = DateTime.strptime(tempDate, "%m/%d/%Y")

      #puts "mealDate " + mealDate
      if tempDateObj <= fromDateObj and tempDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def isDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDateWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    respHeightWeightCount = getTotalCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..respHeightWeightCount
      respHeightWeightDate = getNthDateInRespHeightWeightList(i)
      respHeightWeightDateObj = DateTime.strptime(respHeightWeightDate, "%m/%d/%Y")

      #puts "mealDate " + mealDate
      if respHeightWeightDateObj <= fromDateObj and respHeightWeightDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def verifyEmbeddedPDF(userID)
    element = getElement(:css, "#thumbnailView a")
    hrefLink = element.attribute("href")
    puts "href = " + hrefLink

    return hrefLink.include?('http://localhost:8080/MobileHealthPlatformWeb/rest/patient/EDIPI/' + userID + '/patient-entered-vitals/pdf?')

  end
end