require 'rubygems'
require 'selenium-webdriver'
require 'jquery'

require_relative  "../../module/DriverUtility"
require_relative "../../helpers/entry_form"

class Pain < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"

  def initialize(driver)
    @driver = driver
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end
  
  def getNthDate(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2)")
  end

  def getNthScaleRange(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1)")
  end
  
  def getPainCount()
    elements = getElements(:css, "ul.secondary-list li")
    count = elements.length
    #puts "[getPainCount()] " + count.to_s
    return count
  end
  
  def getNarrativeCounterText()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end

  def getNarrativeText()
    return getTextFromInput(:css, "textarea[name='Note']")
  end
  
  def getPainRangeValue()
    #puts "Slider Value " + getInputRangeValue("pain")
    return getInputRangeValue("pain")
  end

  def getDateLabel()
    return getTextForElement(:css, "form[name='painForm'] div span:nth-of-type(1)")
  end

  def getTimeInForm()
    return getTextFromInput(:css, ".page #time")
  end

  def getDateInForm()
    return getTextFromInput(:css, ".page #date")
  end
  
  def getPainDescription()
    return getTextForElement(:css, "input-range[form-name='painForm'] .input-range-key")
  end
  
  def getPainLabel()
    return getTextForElement(:css, "input-range[form-name='painForm'] .input-range-prompt")
  end
  
  def getNarrativeLabel()
    return getTextForElement(:css, "input-text[name='Note'] span")
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def clickNthPain(number)
    click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end
  
  def clickAddBtn()
    click(:css, "button[ng-click='getDetails()']")
  end

  def clickSaveNewBtn()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickSaveBtn()
    click(:css, "button[ng-click='saveItem()']")
  end

  def clickCancelBtn()
    click(:css, "button[ng-click='cancel()']")
  end
  
  def clickDeleteBtn()
    click(:css, "button[ng-click='deleteItem()']")
  end
  
  def movePainRangeToRight(numberofArrowMove)
    moveArrowInputRangeToRight("pain", numberofArrowMove)
    sleep 1
  end

  def movePainRangeToLeft(numberofArrowMove)
    moveArrowInputRangeToLeft("pain", numberofArrowMove)
    sleep 1
  end
  
  def isSaveButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveNewItem()']").displayed?
  end

  def isSaveExistingEventButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveItem()']").displayed?
  end

  def isDeleteButtonVisible()
    return @driver.find_element(:css, "button[ng-click='deleteItem()']").displayed?
  end

  def isCancelButtonVisible()
    return @driver.find_element(:css, "button[ng-click='cancel()']").displayed?
  end
  
  def is30DaysRange()
    is30DaysRange = false
    fromDateStr = getTextFromInput(:css, "input[name='startDate']")
    toDateStr = getTextFromInput(:css, "input[name='endDate']")
    
    fromDate = DateTime.strptime(fromDateStr, "%m/%d/%Y")
    toDate = DateTime.strptime(toDateStr,"%m/%d/%Y")
    
    #puts "fromdate " + fromDate.to_s
    #puts "toDate " + toDate.to_s
    
    expectedFromDate = DateTime.strptime(30.day.ago.strftime(format= "%m/%d/%Y").to_s, "%m/%d/%Y")
    expectedToDate = DateTime.strptime(0.day.ago.strftime(format= "%m/%d/%Y").to_s, "%m/%d/%Y")
    
    if (fromDate == expectedFromDate and toDate ==  expectedToDate)
      is30DaysRange = true
    end
    
    #puts "[is30DaysRange]30 days ago date " + expectedFromDate.to_s
    #puts "[is30DaysRange] today's date " + expectedToDate.to_s
     
    return is30DaysRange
    
  end
  
  def isDatesWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDatesWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate
    
    painCount =  getPainCount()
    isValid = true
    dateFormat = 
    
    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")
   
    for i in 1..painCount
      dateEntryStr = getNthDate(i)
      dateEntry = DateTime.strptime(dateEntryStr, "%m/%d/%Y")
      
      #puts "[isDatesWithinFilteredDateRange?()] Pain entryDate " + dateEntryStr
      if dateEntry <= fromDateObj and dateEntry >= toDateObj then
        isValid = false
        break
      end
    end
    
    return isValid
    
  end
  
  def setDate(dateStr)
    @driver.find_element(:css, "input[name='date']").clear
    @driver.find_element(:css, "input[name='date']").send_keys(dateStr)
    sleep 1
  end
  
  def setTime(timeStr)
    time = Time.parse(timeStr);
    elem = @driver.find_element(:css, "input[name='time']")
    elem.clear
    elem.send_keys(time.strftime("%I"))
    elem.send_keys [:shift, ";"]
    elem.send_keys(time.strftime("%M %p"))
    sleep 1
  end

  def setNarrativeText(text)
    element =  @driver.find_element(:css, "textarea[name='Note']")
    element.clear
    element.send_keys(text)
    sleep 1
  end

  def add_pain_entry(date, time, num_moves, text)
  paintListCount = getPainCount()

	clickAddBtn
	sleep 1

	setDate(date)
  sleep 0.2
	setTime(time)
  sleep 0.2
	movePainRangeToRight(num_moves)
  sleep 0.2
	setNarrativeText(text)
  sleep 0.2

	clickSaveNewBtn

  !45.times{ break if (getPainCount() == (paintListCount + 1)); sleep 1 }

  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrativeText(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest
  end

  def getMessageInEventDetail
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end

end