require 'rubygems'
require 'selenium-webdriver'
require 'jquery'

require_relative  "../../module/DriverUtility"
require_relative "../../pages/archived/mood"

class Mood  < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  NARRATIVE = "Note"

  def initialize(driver)
    @driver = driver
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def getNthDate(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2)")
  end

  def getDateInForm()
    return getTextFromInput(:css, ".page #date")
  end

  def getNthScaleRange(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1)")
  end

  def getMoodCount()
    elements = getElements(:css, "ul.secondary-list li")
    count = elements.length
    #puts "[getMoodCount()] " + count.to_s
    return count
  end

  def getMoodScaleRange(inputName)
    element = @driver.find_element(:css, "input[name=" + inputName + "]")
    return element.attribute("aria-valuetext").strip
  end

  def getMessageInEventDetail
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end
  
  def getNarrative()
    return getTextFromInput(:css, "textarea[name=" + NARRATIVE + "]")
  end
  
  def getNarrativeTextLength()
    return getTextFromInput(:css, "textarea[name=" + NARRATIVE + "]").length
  end
  
  def getNarrativeCounterText()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end

  def setNarrativeText(text)
    element =  @driver.find_element(:css, "textarea[name='Note']")
    element.clear
    element.send_keys(text)
    sleep 0.5
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def clickAddBtn()
    click(:css, "button[ng-click='getDetails()']")
  end

  def clickSaveNewBtn()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickSaveBtn()
    click(:css, "button[ng-click='saveItem()']")
  end

  def clickCancelBtn()
    click(:css, "button[ng-click='cancel()']")
  end
  
  def clickDeleteBtn()
    click(:css, "button[ng-click='deleteItem()']")
  end

  def clickNthMood(number)
    click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def isSaveButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveNewItem()']").displayed?
  end

  def isSaveExistingEventButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveItem()']").displayed?
  end

  def isDeleteButtonVisible()
    return @driver.find_element(:css, "button[ng-click='deleteItem()']").displayed?
  end

  def isCancelButtonVisible()
    return @driver.find_element(:css, "button[ng-click='cancel()']").displayed?
  end
  
  def is30DaysRange()
    is30DaysRange = false
    fromDateStr = getTextFromInput(:css, "input[name='startDate']")
    toDateStr = getTextFromInput(:css, "input[name='endDate']")
    
    fromDate = DateTime.strptime(fromDateStr, "%m/%d/%Y")
    toDate = DateTime.strptime(toDateStr, "%m/%d/%Y")
    
    #puts "fromdate " + fromDate.to_s
    #puts "toDate " + toDate.to_s
    
    expectedFromDate = DateTime.strptime(30.day.ago.strftime(format= "%m/%d/%Y").to_s, "%m/%d/%Y")
    expectedToDate = DateTime.strptime(0.day.ago.strftime(format= "%m/%d/%Y").to_s, "%m/%d/%Y")
    
    if (fromDate == expectedFromDate and toDate ==  expectedToDate)
      is30DaysRange = true
    end
    
    #puts "[is30DaysRange] 30 days ago date " + expectedFromDate.to_s
    #puts "[is30DaysRange] today's date " + expectedToDate.to_s
     
    return is30DaysRange
    
  end
  
  def isDatesWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "Filter Date Range " + fromDate + " - " + toDate
    
    moodCount =  getMoodCount()
    isValid = true
    dateFormat = 
    
    fromDateObj = DateTime.strptime(fromDate,"%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")
   
    for i in 1..moodCount
      dateEntryStr = getNthDate(i)
      dateEntry = DateTime.strptime(dateEntryStr, "%m/%d/%Y")
      
      #puts "Mood entryDate " + dateEntryStr
      if dateEntry <= fromDateObj and dateEntry >= toDateObj then
        isValid = false
        break
      end
    end
    
    return isValid
    
  end

  def moveMoodRangeToRight(numberofArrowMove)
    moveArrowInputRangeToRight("mood", numberofArrowMove)
  end

  def moveMoodRangeToLeft(numberofArrowMove)
    moveArrowInputRangeToLeft("mood", numberofArrowMove)
  end

  def getMoodRangeValue()
    return getInputRangeValue("mood")
  end

  def setNarrative(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
    sleep 0.5
  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrative(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest

  end
end