require 'rspec'
require 'json'
require 'selenium-webdriver'
require 'rubygems'
require 'uri'
require 'net/http'

require_relative "../../module/DriverUtility"
require_relative "vitals"
module Graph
# class Graph
  include DriverUtility
  CHART_CONTAINER = 'div#vitalChart'
  GRAPH_AND_TABLE_BTN = 'ul.nav > li:nth-child(2) > button'
  GRAPH_PAIN_BTN = 'button[ui-sref="main.pain.graph"]'
  GRAPH_FROM = 'g.highcharts-xaxis-labels > text:first-child > tspan'
  GRAPH_TO = 'g.highcharts-xaxis-labels > text:last-child > tspan'
  HEADING_TEXT = 'div.primary-content h5.ng-scope'
  LEGEND = '.highcharts-legend-item > text'

  # def initialize(driver)
  #   @driver = driver
  # end

  def get_graph_start_date
    return getTextForElement(:css, GRAPH_FROM)
  end

  def get_graph_end_date
    return getTextForElement(:css, GRAPH_TO)
  end

  def click_graph_and_table_btn
    click(:css, GRAPH_AND_TABLE_BTN)
  end

  def click_graph_btn
    click(:css, GRAPH_PAIN_BTN)
  end

  def get_heading_text
    getTextForElement(:css, HEADING_TEXT)
  end

  def get_legend_text
	getTextForElement(:css, LEGEND)
  end

  def convert_date_to_graph_format(date_str)
    new_date = Time.parse(date_str)
    return new_date.strftime("%b %-d")
  end

  def filter_graph_points(points)
    points.reverse # reversing array of points to mimic how they are passed in to javascript function - reverse chronological order

    graphpoints = Array.new
    prev_date = Time.new(1900, 1, 1)

    points.length.times do |idx|
      old_date_str = points[idx]["entryDate"]

      old_date_time_array = old_date_str.split(" ")
      old_date_array = old_date_time_array[0].split("/")
      old_time_array = old_date_time_array[1].split(":")

      curr_date = Time.new(old_date_array[2].to_i, old_date_array[0].to_i, old_date_array[1].to_i, old_time_array[0].to_i, old_time_array[1].to_i, old_time_array[2].to_i)


      if prev_date.year != curr_date.year || prev_date.month != curr_date.month || prev_date.day != curr_date.day
        graphpoints.push(points[idx])
      end

      prev_date = curr_date
    end

    return graphpoints.reverse
  end

  # even though a section needs to be specified, when you pass in any section from Vitals, this
  # method returns a hash of all of the entries from all of Vitals, not just that particular section
  def get_json_entries(section, start_date_str, end_date_str)
    authtoken = get_auth_token('D123401')
    tokenpartone = authtoken.to_s.split(//).first(6).join("").to_s
    tokenparttwo = authtoken.to_s.split(//).last(36).join("").to_s

    headers = {
        'Host' => 'localhost:8080',
        'Accept' => 'application/json, text/plain, */*',
        'Authorization' => tokenpartone.to_s + ' ' + tokenparttwo.to_s,
        'Referer' => '' + BASE_URL + '/',
    }

    uri = URI('http://localhost:8080/MobileHealthPlatformWeb/rest/patient/EDIPI/D123401/patient-entered-vitals?section=' +
               section + '&startDate=' + start_date_str + '&endDate=' + end_date_str)
    http = Net::HTTP.new(uri.host, uri.port)
    call = http.get(uri.path, headers)
    json = call.body
    rubydata = JSON.parse(json)

    return rubydata
  end

end