require 'rubygems'
require 'selenium-webdriver'
require 'rspec'

require_relative  "../../module/DriverUtility"
require_relative "../date_filter"
require_relative "../../helpers/entry_form"

class Exercise < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  EVENT_TITLE = "eventTitle"
  DISTANCE_TEXTFIELD = "input[name='distanceInput']"
  DURATION_TEXTFIELD = "input[name='durationInput']"
  NOTE_TEXTFIELD= "textarea[name='Note']"

  def initialize(driver)
    @driver = driver
    @date_filter = Date_Filter.new(@driver)
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def clickAddActivitiesBtn()
    click(:css, "button[ng-click='getDetails()']")
  end

  def clickSaveNewBtn()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickCancelBtn()
    click(:css, "button[ng-click='cancel()']")
  end

  def clickSaveExistingActivityBtn()
    click(:css, "button[ng-click='saveItem()']")
  end

  def clickDeleteBtn()
    click(:css, "button[ng-click='deleteItem()']")
  end

  def clickNthActivity(number)
    click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def getNarrative()
    return getTextFromInput(:css, "textarea[name='Note']")
  end

  def selectActivity(type)
    setSelectBoxValue("select[name='activityInput']",type)
  end

  def selectIntensity(level)
    setSelectBoxValue("select[name='intensityInput']",level)
    end

  def setDistance(textfield)
    setInput(DISTANCE_TEXTFIELD, textfield)
  end

  def setDuration(textfield)
    setInput(DURATION_TEXTFIELD, textfield)
  end

  def setNote(textfield)
    setInput(NOTE_TEXTFIELD,textfield)
  end

  def setNarrative(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
    sleep 1
  end

  def setDateRange(fromDate, toDate)
    @date_filter.setDateRangeAndFilter(fromDate, toDate)
    waitForPageToFinishLoading
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def verifyDefautDateRangeIs30DaysBack()
    verifiedYes = false
    todayDate = getDateNthDaysAgo(0, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    fromDate = getTextFromInput(:css, "input[name='startDate']")

    toDate = getTextFromInput(:css, "input[name='endDate']")
    if toDate == todayDate and fromDate == thirtyDaysAgo then
      verifiedYes = true
    end
  end

  def isDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDateWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    listCount = getTotalItemCountInList()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..listCount
      listDateTime = getNthDateTimeInList(i)
      listDateArry = listDateTime.split(" ")
      listDate = listDateArry[0]
      listDateObj = DateTime.strptime(listDate, "%m/%d/%Y")

      #puts "listDate " + listDate
      if listDateObj <= fromDateObj and listDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def getNthDateTimeInList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1) div:nth-of-type(2)")
  end

  def getNthActivityInList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1) div:nth-of-type(1) strong")
  end

  def getNthIntensityInList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2) div:nth-of-type(1)")
  end

  def getNthDistanceInList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2) div:nth-of-type(2)")
  end

  def getNthLabelDistance()
    element = getElement(:name, 'distanceInput')
    return element.attribute('label')
  end

  def getNthDurationInList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(3) div")
  end

  def getNthLabelDuration()
    element = getElement(:name, 'durationInput')
    return element.attribute('label')
  end

  def getMessageInDetailScreen()
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end

  def getTotalItemCountInList()
    begin
      elements = getElements(:css, "ul.secondary-list li strong")
      return elements.length
    rescue Exception=>e
      puts "Exception " + e.to_s
      return 0
    end
  end

  def findIndexWithAGivenActivityType(activityType)
    listLength = getTotalItemCountInList()
    #puts "List Length : " + listLength.to_s
    index = -1

    for i in 1..listLength
      #puts "listtype = " + getNthActivityInList(i)
      listtype = getNthActivityInList(i)
      if listtype == activityType then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    return index
  end

  def isThisItemDisplayed?(activityType)
    isDisplaying = false
    rowIndex = findIndexWithAGivenActivityType(activityType)
    if(rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end

  def addAnActivity(dateStr, timeStr, type, level, miles, minutes, text)
    #Do an initial list count
    listCount = getTotalItemCountInList()
    #puts listCount

    clickAddActivitiesBtn()
    waitForPageToFinishLoading
    getPrimaryHeader().should == "Add Exercise Entry"

    setDateAndTime(dateStr, timeStr, "input[name='date']", "input[name='time']")
    selectActivity(type)
    selectIntensity(level)
    setDistance(miles)
    setDuration(minutes)
    setNarrative(text)
    clickSaveNewBtn()

    #Do the list count again to see if had increment by 1
    #puts "@exercise.getTotalItemCountInList() = " + getTotalItemCountInList().to_s
    waitForPageToFinishLoading

  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrative(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest
  end

  def EditAnActivity(number)
    setDuration(number)
    #clickSaveExistingActivityBtn()
    clickSaveNewBtn()
  end

#"%Y-%m-%d"
  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo

  end

end