require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"
require_relative "../date_filter"
require_relative "../../helpers/entry_form"


class Diet < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  EVENT_TITLE = "eventTitle"
  SELECT_BOX_MEAL_TYPE = "select[name='Meal Type']"
  CALORIES_TEXTFIELD = "input[name='caloriesInput']"
  FAT_TEXTFIELD = "input[name='fatInput']"
  CARBS_TEXTFIELD = "input[name='carbInput']"
  PROTEIN_TEXTFIELD = "input[name='proteinInput']"
  NOTE_TEXTFIELD= "textarea[name='Note']"

  def initialize(driver)
    @driver = driver
    @date_filter = Date_Filter.new(@driver) 
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def clickAddMealBtn()
    click(:css, "button[ng-click='getDetails()']")
  end

  def clickSaveNewBtn()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickCancelBtn()
    click(:css, "button[ng-click='cancel()']")
  end

  def clickSaveExistingMealBtn()
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickDeleteBtn()
    click(:css, "button[ng-click='deleteItem()']")
  end

  def clickNthMeal(number)
    click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def selectType(type)
    select = getElement(:css, "select[name='Meal Type']")
    options = select.find_elements(:tag_name, "option").select
    options.each do |option|
      if(option.attribute('value') == type)
        option.click
        break
      end
    end
  end

  def selectBoxMealType(meal_type)
    setSelectBoxValue(SELECT_BOX_MEAL_TYPE,meal_type)
  end

  def setCalories(calories_textfield)
    setInput(CALORIES_TEXTFIELD, calories_textfield)
  end

  def setFat(textfield)
    setInput(FAT_TEXTFIELD, textfield)
  end

  def setCarb(carbs_textfield)
    setInput(CARBS_TEXTFIELD, carbs_textfield)
  end

  def setProtein(protein_textfield)
    setInput(PROTEIN_TEXTFIELD, protein_textfield)
  end

  def setNarrative(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
  end

  def setNote(textfield)
    setInput(NOTE_TEXTFIELD,textfield)
  end

  def setDateRange(fromDate, toDate)
    @date_filter.setDateRangeAndFilter(fromDate, toDate)
    sleep 5
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end
  
  def verifyDefautDateRangeIs30DaysBack()
    verifiedYes = false
    todayDate = getDateNthDaysAgo(0, "%m/%d/%Y")
    thirtyDaysAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    fromDate = getTextFromInput(:css, "input[name='startDate']")

    toDate = getTextFromInput(:css, "input[name='endDate']")
    if toDate == todayDate and fromDate == thirtyDaysAgo then
      verifiedYes = true
    end
  end

  def isDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDateWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    mealCount = getTotalMealCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..mealCount
      mealDateTime = getNthDateTimeInMealList(i)
      mealDateArry = mealDateTime.split(" ")
      mealDate = mealDateArry[0]
      mealDateObj = DateTime.strptime(mealDate, "%m/%d/%Y")

      #puts "mealDate " + mealDate
      if mealDateObj <= fromDateObj and mealDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def getNthDateTimeInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1) div:nth-of-type(2)")
  end

  def getNthCaloriesInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2) div:nth-of-type(1)")
  end

  def getNthTypeInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(1) div:nth-of-type(1) strong")
  end

  def getNthFatInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(2) div:nth-of-type(2)")
  end

  def getNthCarbInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(3) div:nth-of-type(1)")
  end

  def getNthProteinInMealList(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div:nth-of-type(3) div:nth-of-type(2)")
  end

  def getNthLabelCalories()
    return getTextForElement(:css, "#caloriesInput div label span span:nth-of-type(1)")
  end

  def getNthLabelFat()
    return getTextForElement(:css, "#fatInput div label span span:nth-of-type(1)")
  end

  def getNthLabelCarbs()
    return getTextForElement(:css, "#carbInput div label span span:nth-of-type(1)")
  end

  def getNthLabelProtein()
    return getTextForElement(:css, "#proteinInput div label span span:nth-of-type(1)")
  end

  def getMessageInEventDetail()
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end

  def getTotalMealCount()
    begin
      elements = getElements(:css, "ul.secondary-list li strong")
      return elements.length
    rescue Exception=>e
      puts "Exception " + e.to_s
      return 0
    end
  end

  def findIndexWithAGivenMealType(mealType)
    mealLength = getTotalMealCount()
    #puts "Meal Length : " + mealLength.to_s
    index = -1

    for i in 1..mealLength
      #puts "listtype = " + getNthTypeInMealList(i)
      listtype = getNthTypeInMealList(i)
      if listtype == mealType then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    return index
  end

  def isThisMealDisplayed?(mealType)
    isDisplaying = false
    rowIndex = findIndexWithAGivenMealType(mealType)
    if(rowIndex > 0)
      isDisplaying = true
    end
    return isDisplaying
  end

  def addAMeal(dateStr, timeStr, type, calories, fat, carb, protein, text)
    clickAddMealBtn()
    !15.times{ break if (getPrimaryHeader() == "Add Diet Entry"); sleep 1 }
    getPrimaryHeader().should == "Add Diet Entry"

    setDateAndTime(dateStr, timeStr, "input[name='date']", "input[name='time']")
    sleep 0.5
    selectType(type)
    sleep 0.2
    setCalories(calories)
    sleep 0.2
    setFat(fat)
    sleep 0.2
    setCarb(carb)
    sleep 0.2
    setProtein(protein)
    sleep 0.2
    setNarrative(text)
    sleep 0.2
    clickSaveNewBtn()
  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrative(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest
  end

  def EditAMeal(number)
    setCalories(number)
    clickSaveExistingMealBtn()
  end

#"%Y-%m-%d"
  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)
    return dateNthDaysAgo

  end



  def breakfast_Entry

      mealCount = 0
      time = Time.new
      today = time.strftime("%m/%d/%Y")
      #puts today
      morningTime = "08:00 AM"
      noonTime = "12:00 PM"
      dinnerTime = "06:00 PM"
      snackTime = "03:00 PM"

      yesterday = @diet.getDateNthDaysAgo(1, "%m/%d/%Y")

      clickAddMealBtn
      waitForPageToFinishLoading
      @driver.find_element(:id, "date").clear
      sleep 1
      @driver.find_element(:id, "date").send_keys (yesterday)
      sleep 1
      @driver.find_element(:id, "time").clear
      sleep 1
      @driver.find_element(:id, "time").send_keys (morningTime)
      sleep 1
      @driver.find_element(:css, "select[name='Meal Type']").send_keys "Breakfast"
      waitForPageToFinishLoading
      @driver.find_element(:css, "input[name='caloriesInput']").send_keys "300"
      sleep 1
      @driver.find_element(:css, "input[name='fatInput']").send_keys "10"
      sleep 1
      @driver.find_element(:css, "input[name='carbInput']").send_keys "50"
      sleep 1
      @driver.find_element(:css, "input[name='proteinInput']").send_keys "14"
      sleep 1
      @driver.find_element(:css, "textarea[name='Note']").send_keys "Delicious"
      sleep 1
      clickSaveButton
      waitForPageToFinishLoading
  end

  # def lunch_Entry
  #
  #     mealCount = 0
  #     time = Time.new
  #     today = time.strftime("%m/%d/%Y")
  #     #puts today
  #     morningTime = "08:00 AM"
  #     noonTime = "12:00 PM"
  #     dinnerTime = "06:00 PM"
  #     snackTime = "03:00 PM"
  #
  #     yesterday = @diet.getDateNthDaysAgo(1, "%m/%d/%Y")
  #
  #     clickAddMealBtn
  #     waitForPageToFinishLoading
  #     @driver.find_element(:id, "date").clear
  #     sleep 1
  #     @driver.find_element(:id, "date").send_keys (yesterday)
  #     sleep 1
  #     @driver.find_element(:id, "time").clear
  #     sleep 1
  #     @driver.find_element(:id, "time").send_keys (noonTime)
  #     sleep 1
  #     @driver.find_element(:css, "select[name='Meal Type']").send_keys "Lunch"
  #     waitForPageToFinishLoading
  #     @driver.find_element(:css, "input[name='caloriesInput']").send_keys "600"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='fatInput']").send_keys "20"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='carbInput']").send_keys "50"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='proteinInput']").send_keys "33"
  #     sleep 1
  #     @driver.find_element(:css, "textarea[name='Note']").send_keys "I enjoyed the meal"
  #     sleep 1
  #     clickSaveButton
  #     waitForPageToFinishLoading
  #
  # end
  #
  # def snack_Entry
  #
  #     mealCount = 0
  #     time = Time.new
  #     today = time.strftime("%m/%d/%Y")
  #     #puts today
  #     morningTime = "08:00 AM"
  #     noonTime = "12:00 PM"
  #     dinnerTime = "06:00 PM"
  #     snackTime = "03:00 PM"
  #
  #     yesterday = @diet.getDateNthDaysAgo(1, "%m/%d/%Y")
  #
  #     clickAddMealBtn
  #     waitForPageToFinishLoading
  #     @driver.find_element(:id, "date").clear
  #     sleep 1
  #     @driver.find_element(:id, "date").send_keys (yesterday)
  #     sleep 1
  #     @driver.find_element(:id, "time").clear
  #     sleep 1
  #     @driver.find_element(:id, "time").send_keys (snackTime)
  #     sleep 1
  #     @driver.find_element(:css, "select[name='Meal Type']").send_keys "Snack"
  #     waitForPageToFinishLoading
  #     @driver.find_element(:css, "input[name='caloriesInput']").send_keys "150"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='fatInput']").send_keys "7"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='carbInput']").send_keys "30"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='proteinInput']").send_keys "9"
  #     sleep 1
  #     @driver.find_element(:css, "textarea[name='Note']").send_keys "Yummy protein bar."
  #     sleep 1
  #     clickSaveButton
  #     waitForPageToFinishLoading
  #
  # end
  #
  # def dinner_Entry
  #     mealCount = 0
  #     time = Time.new
  #     today = time.strftime("%m/%d/%Y")
  #     #puts today
  #     morningTime = "08:00 AM"
  #     noonTime = "12:00 PM"
  #     dinnerTime = "06:00 PM"
  #     snackTime = "03:00 PM"
  #
  #     yesterday = @diet.getDateNthDaysAgo(1, "%m/%d/%Y")
  #
  #     clickAddMealBtn
  #     waitForPageToFinishLoading
  #     @driver.find_element(:id, "date").clear
  #     sleep 1
  #     @driver.find_element(:id, "date").send_keys (yesterday)
  #     sleep 1
  #     @driver.find_element(:id, "time").clear
  #     sleep 1
  #     @driver.find_element(:id, "time").send_keys (dinnerTime)
  #     sleep 1
  #     @driver.find_element(:css, "select[name='Meal Type']").send_keys "Dinner"
  #     waitForPageToFinishLoading
  #     @driver.find_element(:css, "input[name='caloriesInput']").send_keys "800"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='fatInput']").send_keys "24"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='carbInput']").send_keys "55"
  #     sleep 1
  #     @driver.find_element(:css, "input[name='proteinInput']").send_keys "37"
  #     sleep 1
  #     @driver.find_element(:css, "textarea[name='Note']").send_keys "I did not feel stuffed after dinner."
  #     sleep 1
  #     clickSaveButton
  #     waitForPageToFinishLoading
  # end

end