require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"


class Daily_events < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  EVENT_TITLE = "eventTitle"
  PDF_BTN = 'button[ng-click="fetchEventDetailAsPdf()"]'

  def initialize(driver)
    @driver = driver
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def clickFilterButton()
    click(:css, "button[ng-click='filter()']")
  end

  def clickAddEvent()
    click(:css, "button[ng-click='addDailyEvent()']")
  end

  def clickAddAttachmentButton()
    click(:css, "button[name='addEventAttachment']")
  end

  def clickNthEvent(number)
    click(:css, "ul.secondary-list li:nth-child(" + number.to_s + ") button")
  end

  def clickSaveNewEventButton()
    @driver.find_element(:css, "button[ng-click='saveNewEvent()']").click
  end

  def clickSaveExistingEventButton()
    @driver.find_element(:css, "button[ng-click='saveEvent()']").click
  end

  def clickDeleteButton
    @driver.find_element(:css, "button[ng-click='deleteEvent()']").click
  end

  def clickCancelButton
    @driver.find_element(:css, "button[ng-click='cancel()']").click
  end

  def isSaveButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveNewEvent()']").displayed?
  end

  def isSaveExistingEventButtonVisible()
    return @driver.find_element(:css, "button[ng-click='saveEvent()']").displayed?
  end

  def isSaveButtonPresent()
    begin
      element = @driver.find_element(:css, "button[ng-click='saveEvent()']")
      return element.displayed?
    rescue Exception=>e
      return false
    end
  end

  def isDeleteButtonVisible()
    return @driver.find_element(:css, "button[ng-click='deleteEvent()']").displayed?
  end

  def isCancelButtonVisible()
    return @driver.find_element(:css, "button[ng-click='cancel()']").displayed?
  end

  def getSaveButtonText()
    return getTextForElement(:css,"button[ng-click='saveNewEvent()']")
  end

  def getEventTitle()
    return getTextFromInput(:css, "input[name='eventTitle']")
  end

  def getMessageInEventDetail
    puts "[getMessageInEventDetail()] " + getTextForElement(:css, "div[ng-if='!details'] span")
    return getTextForElement(:css, "div[ng-if='!details'] span")
  end

  def getPrimaryContent()
    return getTextForElement(:css, "div[ui-view='primary'] div")
  end

  def getAttachmentLabel()
    return getTextForElement(:css, "div h5")
  end

  def setEventText(text)
    @driver.find_element(:css, "input[name='eventTitle']").clear
    @driver.find_element(:css, "input[name='eventTitle']").send_keys(text)
  end

  def setEventNote(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
  end

  def setNarrative(text)
    @driver.find_element(:css, "textarea[name='Note']").clear
    @driver.find_element(:css, "textarea[name='Note']").send_keys(text)
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def getNthEventText(number)
    return getTextForElement(:css, SCOPE_SELECTOR + "li:nth-of-type(" + number.to_s + ")")
  end

  def getNthEventTimeStamp(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-child(" + number.to_s + ") button div:nth-child(2)")
  end

  def getTimeInForm()
    return getTextFromInput(:css, ".page #time")
  end

  def getDateInForm()
    return getTextFromInput(:css, ".page #date")
  end

  def getTextLength(text)
    return text.length
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def clickDeleteButton
    click(:css, "button[ng-click='deleteEvent()']")
  end

  def addNewEvent(dateStr, timeStr, eventLog, noteLog)
    eventsListCount = getDailyEventsCount()
    clickAddEvent()
    !45.times{ break if (getSaveButtonText() == "Save"); sleep 1 }

    setDateAndTime(dateStr, timeStr, "input[name='date']", "input[name='time']")
    setEventText(eventLog)
    setEventNote(noteLog)

    clickSaveNewEventButton()

    !45.times{ break if (getDailyEventsCount() == (eventsListCount + 1 )); sleep 1 }

  end

  def isPDFButtonDisplayed?()
    return isElementVisible(:css, PDF_BTN)
  end

  def clickPDFBtn
    click(:css, PDF_BTN)
  end

  #userID = D123401
  def verifyEmbeddedPDF()
    urlLink = @driver.current_url
    puts "PDF URL is " + urlLink

    return urlLink.include?('pdf?')

  end

  def editNthEvents(number, eventLog)

    clickNthEvent(number)

    !45.times{ break if (isSaveExistingEventButtonVisible == true); sleep 1 }

    setEventText(eventLog)

    clickSaveExistingEventButton()

    !45.times{ break if (isSaveButtonPresent == false); sleep 1 }

  end

  def getDailyEventsCount()
    return getElements(:css, "ul.secondary-list li").length
  end

  def findIndexWithGivenEventTitle(eventTitle)
    eventListLength = getElements(:css, "ul.secondary-list li").length
    #puts "EventList Length : " + eventListLength.to_s
    index = -1

    for i in 1..eventListLength
      event = getNthEventText(i)
      if event == eventTitle then
        index = i
        break
      end
    end
    #puts "rowIndex found : " + index.to_s
    return index
  end

  def isEventsDisplayed?(eventTitle)
    isDisplayed = false
    rowIndex = findIndexWithGivenEventTitle(eventTitle)
    if(rowIndex > 0)
      isDisplayed = true
    end

    return isDisplayed

  end

  def printEventTimeStampAndTitle()
    eventListLength = getElements(:css, "ul.secondary-list li").length
    #puts "EventList Length : " + eventListLength.to_s

    for i in 1..eventListLength
      event = getNthEventText(i)
      timeStamp = getNthEventTimeStamp(i)
      #puts event + "      " + timeStamp
    end

  end

  def isThisButtonVisible(buttonCSS)
    begin
      element = @driver.find_element(:css, buttonCSS)
      return element.displayed?
    rescue Exception => e
      return false
    end
  end

  def isEventMovedToFirstRow(newEventTitle)
    isFirstRow = false
    rowIndex = findIndexWithGivenEventTitle(newEventTitle)

    if(rowIndex == 1)
      isFirstRow = true
    end

    return isFirstRow
  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNarrative(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest

  end

  def isDatesWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")
    #puts "[isDatesWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    logCount = getCommunicationsLogCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..logCount
      logDate = getNthDateInCommList(i)
      logDateObj = DateTime.strptime(logDate, "%m/%d/%Y")

      #puts "logDate " + logDate
      if logDateObj <= fromDateObj and logDateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def addImageAttachment(filename)
    uploadBtn = getElement(:css, "input[type='file']")
    puts File.dirname(__FILE__) + "/../resources/"
    uploadBtn.send_keys (File.dirname(__FILE__) + "/../resources/" +filename)
  end

  def deleteAttachment(buttonCSS)
    click(:css, buttonCSS)
  end

end