require 'rubygems'
require 'selenium-webdriver'

require_relative '../../../selenium-ruby/module/DriverUtility'
require_relative '../../../../acceptance_test/selenium-ruby/pages/modal_popup'

class AppTour
  include DriverUtility

  USER_NAME = 'AI'
  PASSWORD = 'AI'
  SIGN_IN = 'loginButton'
  VERIFY_BUTTON = 'verify-btn'

  APP_TOUR_CAROUSEL_ID = 'carousel'
  APP_TOUR_MODAL_HEADER = 'Take a Tour'
  APP_TOUR_LEFT_BUTTON = "button[title='Previous Screen']"
  APP_TOUR_RIGHT_BUTTON = "button[title='Next Screen']"
  APP_TOUR_CLOSE_BUTTON = 'waitingRoomButton'
  APP_TOUR_DO_NOT_SHOW_AGAIN_BUTTON = "a[ng-click=\"onClicked()\"]"
  APP_TOUR_SLIDE_IMAGE = "img[class='carousel-img']"

  APP_TOUR_SLIDE_IMAGES = {
    'slide_1' => '_assets/images/tour/0000_menu.jpg',
    'slide_2' => '_assets/images/tour/0001_categories.jpg',
    'slide_3' => '_assets/images/tour/0002_add.jpg',
    'slide_4' => '_assets/images/tour/0003_useropen.jpg',
    'slide_5' => '_assets/images/tour/0004_launchpad.jpg'
  }

  def initialize(driver)
    @driver = driver
    @main = Main.new(driver)
    @eula = Eula.new(driver)
    @menu = Menu.new(driver)
    @modal_popup_instance = Modal_popup.new(driver)
    @pleasenote = PleaseNote.new(driver)
    @loginpage = Login_Screen.new(driver)
    @landing = Landing_screen.new(driver)
  end

  def isAppTourModalVisible()
    waitForPageToFinishLoading
    return isElementVisible(:id, APP_TOUR_CAROUSEL_ID)
  end

  def isAppTourModalHeaderTextCorrect()
    return @modal_popup_instance.getConfirmationHeading == APP_TOUR_MODAL_HEADER
  end

  def isAppTourNthSlideImageVisible(slideNumber)
    waitForPageToFinishLoading
    return isElementVisible(:css, "img[ng-src='" + APP_TOUR_SLIDE_IMAGES['slide_' + slideNumber.to_s] + "']")
  end

  def clickAppTourLeftButton()
    click(:css, APP_TOUR_LEFT_BUTTON)
  end

  def isAppTourLeftButtonVisible()
    return isElementVisible(:css, APP_TOUR_LEFT_BUTTON)
  end

  def clickAppTourRightButton()
    click(:css, APP_TOUR_RIGHT_BUTTON)
  end

  def isAppTourRightButtonVisible()
    return isElementVisible(:css, APP_TOUR_RIGHT_BUTTON)
  end

  def clickAppTourCloseButton()
    waitForPageToFinishLoading
    click(:id, APP_TOUR_CLOSE_BUTTON)
  end

  def clickAppTourDoNotShowAgainButton()
    waitForPageToFinishLoading
    click(:css, APP_TOUR_DO_NOT_SHOW_AGAIN_BUTTON)
  end

  def loginForAppTour(loginId, userNameOnFooter)
    waitForPageToFinishLoading
    @main.clickUserMenu()
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    @menu.clickLogoutBtn()

    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }

    sleep(5)
    @driver.execute_script("$('a[href=\"/my-va-health\"]')[0].scrollIntoView(true)")
    click(:css, 'a[href="/my-va-health"')
    !15.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }

    waitForPageToFinishLoading
    if @eula.acceptEulaVisible?
      @eula.clickAccept()
    end

    @loginpage.passingByTheLandingPage()

    !15.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }

    sleep 10
    !45.times{ break if (is_element_present(:id, USER_NAME)); sleep 1 }
    if is_element_present(:id, USER_NAME) then
      @driver.find_element(:id, USER_NAME).send_keys(loginId)
      @driver.find_element(:id, PASSWORD).send_keys("pass")
      sleep 1
      click(:id, SIGN_IN)
      sleep 2
    end

    #To check if the ROA screen is present
    if is_element_present(:css, "button[data-theme='b'][aria-disabled='false']") then
      click(:css, "button[data-theme='b'][aria-disabled='false']")

      !15.times{ break if (getPageTitle() == "Review"); sleep 1 }
      click(:id, VERIFY_BUTTON)
      sleep 1
    end

    sleep 5

    #To check if the Time Zone selection screen is present
    waitForPageToFinishLoading
    if is_element_present(:css, "button[ng-click='save()']") then
      #puts "Initializing user Notification Setting and the Time Zone selection."
      sleep 5
      byPassTheNotificationSettingsScreen()
    end

    waitForPageToFinishLoading
    if is_element_present(:css, "input[id='no-show-notice']") then
      click(:css, "input[id='no-show-notice']")
      @pleasenote.clickAccept
    end

    waitForPageToFinishLoading
    if @main.getNotificationText == "Notification Settings"
      byPassTheNotificationSettingsScreen
    else
      puts 'Notification Settings page did not exits'
    end

    sleep 5

    if is_element_present(:css, "input[id='no-show-notice']") then
      waitForPageToFinishLoading
      click(:css, "input[id='no-show-notice']")
      @pleasenote.clickAccept
    else
      waitForPageToFinishLoading
    end

    ####################################DEMO#######################################################

    # @loginpage.passingByTheLandingPage()
    # !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    # @loginpage.loginAsVeteran(loginId)

    !45.times{ break if (@main.getFooterText() == "Logged in as " + userNameOnFooter); sleep 1 }
  end
end