require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class About
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def parse(val)
    @parsed_value = JSON.parse(val)
  end
  
  def getAboutHeading()
    return getTextForElement(:css, "div[class='modal-header ng-scope'] h3")
  end

  def getVersionFromApp()
    #refillContent > p:nth-of-type(1)
    !10.times{ break if (is_element_present(:id, "about")); sleep 1 }
    displayedString = getTextForElement(:css, "div[class='modal-body ng-scope'] p:nth-of-type(1)")
    newArray = displayedString.split("- ")
    version = newArray[1]
    puts "App Version is : " + version
    return version

  end

  def getVersionFromVersionFile()
    versionJsonPath = File.dirname(__FILE__) + "/../../../dist/version.json"
    puts versionJsonPath

    jsonfile = File.open(versionJsonPath).read
    versionJson= parse(jsonfile.to_s())

    puts 'version json:  ' +versionJson.to_s()
    return ('v' + versionJson['version'] )

  end
  
  def getAboutText()
    return getTextForElement(:css, "div.modal-body")
  end

  def clickOKfromAboutScreen()
    !45.times{ break if (is_element_present(:css,"button[ng-click='ok()']")); sleep 1 }
    click(:css, "button[ng-click='ok()']" )
  end

  def clickShowEULA()
    click(:css, "a[ng-click='showEula()']")
  end

end