require 'rubygems'
require 'selenium-webdriver'
require 'rspec'

require_relative  "../module/DriverUtility"


module TypeaheadSelectionList
  include DriverUtility

  def typeaheadField()
    return getElement(:css, "input-type-ahead input")
  end

  def setTypeaheadField(value)
    setInputField(getElement(:css, "input-type-ahead input"), value)
  end

  def setInputField(field, value)
    field.clear
    field.send_keys(value.to_s)
    sleep 0.5
  end

  def getSelectListCSS()
    return "input-type-ahead ul li"
  end

  def getSelectList()
    return getElements(:css, "input-type-ahead ul li")
  end

  def getSelectListText()
    elems = getSelectList()
    textArray = []
    elems.each_with_index do | elem, i|
      #puts "arraytext=[#{elem}]"
      textArray << elem.text
    end
    return textArray
  end


  def selectSelectListItemByIndex(nbr)
    elems = getSelectList()
    elems[nbr].click
    sleep 0.5
  end


  def selectSelectListItemByName(name)
    elems = getSelectList()
    elems.each_with_index do | elem, i|
      #puts "Comparing [#{elem.text.upcase}] == [#{name.upcase}]"
      if elem.text.upcase == name.upcase
        elems[i].click
        sleep 0.5
        break
      end
    end
  end


  def getSelectListCount()
    return getSelectList().length
  end


  def getSNOMEDInfo(collection, db, info, name)
    coding = nil
    docs = retreiveAllDocumentsInCollection(collection, db)
    if info == ""
      # for diagnosis type format
      docs.each_with_index do | doc, i|
        ## Each section uses a different attribute to store the name
        ## Diagnosis: patientDiagnosis, Surgeries: name, Symptoms: description
        if (doc["patientDiagnosis"] == name || doc["name"] == name || doc["description"] == name)
          if doc["coding"] == nil
            coding = []
          else
            coding = doc["coding"]
          end
          return coding
        end
      end
    else
      # for medication type format
      docs.each_with_index do | doc, i|
        #puts "comparing [#{doc[info]['name']}] with [#{name}]"
        if doc[info]["name"] == name
          if doc[info]["coding"] == nil
            coding = []
          else
            coding = doc[info]["coding"][0]
          end
          return coding
        end
      end
    end
    return coding
  end


end