require 'rubygems'
require 'selenium-webdriver'
require 'rspec'

require_relative  "../module/DriverUtility"


module Table
  include DriverUtility

  SCOPE_SELECTOR = ".list-table "

  def getCount()
    begin
      waitForPageToFinishLoading
      return getElements(:css, SCOPE_SELECTOR + "li").length
    rescue Exception => e
      return 0
    end
  end

  def getList()
    return getElements(:css, SCOPE_SELECTOR + "li")
  end

  def getTableHeaders()
    listHeaders = getElements(:css, SCOPE_SELECTOR + ".header > div > span > span")
    headerCount = listHeaders.length
    headers = []
    for i in 0...headerCount
      if listHeaders[i].displayed?
        headers << listHeaders[i].text.strip
      end
    end
    return headers
  end

  def clickReviewYourInfoSaveButton()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='save()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    sleep 2.5
  end

  def clickNthRow(row)
    waitForPageToFinishLoading
    clickRowJquery(SCOPE_SELECTOR + "li:nth-of-type(" + row.to_s + ")")
    click(:css, SCOPE_SELECTOR + "li:nth-of-type(" + row.to_s + ")")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickNthRowGoal(row)
    clickRowJqueryGoals(SCOPE_SELECTOR + "li:nth-of-type(" + row.to_s + ")")
  end

  def getTextForRowColumn(row, column)
    return getTextForElement(:css, SCOPE_SELECTOR + "li:nth-of-type(" + row.to_s + ") span:nth-of-type(" + column.to_s + ") .cell-content")
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def getTextForRow(row)
    return getTextForElement(:css, SCOPE_SELECTOR + "li:nth-of-type(" + row.to_s + ")")
  end

  def getTextForRowAsArray(row)
    elementText = getTextForRow(row)
    textParts = elementText.split("\n")
    cleanTextParts = []

    textParts.each do | item |
      item.strip!
      cleanTextParts.push(item)
    end

    return cleanTextParts
  end

  def getDataForRow(headers, row)
    dataElements = getElements(:css, SCOPE_SELECTOR + 'li:nth-of-type(' + row.to_s + ') > span')
    numColumns = dataElements.length
    dataHash = {}
    for i in 1..numColumns
      dataHash[headers[i - 1]] = getTextForRowColumn(row, i)
    end

    return dataHash    
  end


  def isSortedByChronologicalOrder(dateOrDateTimeFormat, column)
    #e.g. dateOrDateTimeFormat = "%m/%d/%Y"  (mm/dd/yyyy)
    # or dateOrDateTimeFormat = "%m/%d/%Y %I:%M %p" (mm/dd/yyyy hh:mm AM/PM)

    sortedCorrectly = true

    groupLength = getCount()
    #puts "groupLength=" + groupLength.to_s

    displayedDate = getTextForRowColumn(1, column)
    previousDate = DateTime.strptime(displayedDate, format=dateOrDateTimeFormat)
    #puts "previousDate=" + displayedDate

    for i in 2..groupLength

      displayedDate = getTextForRowColumn(i, column)
      #puts "i, displayedDate=" + i.to_s + " " + displayedDate

      thisDate = DateTime.strptime(displayedDate, format=dateOrDateTimeFormat)
      #puts "thisDate=" + thisDate

      if(previousDate > thisDate) then

        sortedCorrectly = false
        break

      end

      previousDate = thisDate
      #puts "previousDate=" + displayedDate

    end

    return sortedCorrectly
  end

  def isSortedAlphabeticallyByThisColumn(column)
    sortedCorrectly = true

    groupLength = getCount()
    #puts "groupLength=" + groupLength.to_s

    previousText = getTextForRowColumn(1, column)
    #puts "previousText=" + previousText

    for i in 2..groupLength

      thisText = getTextForRowColumn(i, column)
      #puts "i, thisText=" + i.to_s + " " + thisText

      if(previousText > thisText) then

        sortedCorrectly = false
        break

      end

      previousText = thisText
      #puts "previousText=" + previousText

    end

    return sortedCorrectly
  end

  def isThisTextInTheSearchField(text, column)

    findItSuccessfully = true

    for i in 1..getCount()
      returnedText = getTextForRowColumn(i, column)
      if returnedText.downcase.include?(text.downcase) != true then
        findItSuccessfully = false
        break
      end
    end

    return findItSuccessfully
  end

end