require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"


module Graph
  include DriverUtility

  def tableButton()
    return 'button[title="Table"]'
  end

  def graphButton()
    return 'button[title="Graph"]'
  end

  def noResultsFoundMessage()
    return '.no-results-message'
  end

  def viewTableMessage()
    return '.reference-table-message'
  end

  def graphContainer(nth=1)
    return "#graph-#{nth.to_s}"
  end

  def getXAxisLabels(nth=1)
    elements = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-axis > .highcharts-xaxis-title")
    axisLabels = []
    elements.each { |element|
      axisLabels.push(element.text.strip)
    }
    return axisLabels
  end

  def getXAxisValues(nth=1)
    elements = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-xaxis-labels")
    axisValues = []
    elements.each { |element|
      axisValues.push(element.text)
    }
    return axisValues
  end

  def getYAxisLabels(nth=1)
    elements = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-axis > .highcharts-yaxis-title")
    axisLabels = []
    elements.each { |element|
      axisLabels.push(element.text.strip)
    }
    return axisLabels
  end

  def getYAxisValues(nth=1)
    elements = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-yaxis-labels")
    axisValues = []
    elements.each { |element|
      axisValues.push(element.text)
    }
    return axisValues
  end

  def getXAxisTicks(nth=1)
    ticks = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-xaxis-labels > text")
    text = []
    ticks.each { |tick|
      text.push(tick.text)
    }
    return text
  end

  def getYAxisTicks(nth=1)
    ticks = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-yaxis-labels > text")
    text = []
    ticks.each { |tick|
      text.push(tick.text)
    }
    return text
  end

  def getNumberOfPoints(nth=1)
    return getElements(:css, "svg:nth-of-type(#{nth.to_s}) g.highcharts-markers > path").length
  end

  def getNumberOfBars(nth=1)
    return getElements(:css, "#graph-#{nth.to_s} svg > g.highcharts-series-group > g.highcharts-series > rect:not([height='0'])").length
  end

  def isGraphButtonDisplayed?()
    return isElementVisible(:css, GRAPH_BTN)
  end

  def isTableButtonDisplayed?()
    return isElementVisible(:css, TABLE_BTN)
  end

  def clickGraphButton()
    click(:css, GRAPH_BTN)
  end

  def clickTableButton()
    click(:css, TABLE_BTN)
  end

  def isLegendDisplayed?(nth=1)
    return isElementVisible(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-legend")
  end

  def getLegendContent(nth=1)
    return getTextForElement(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-legend")
  end

  def getLegendTextAndColor(nth=1)
    colors = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-legend > g > g > .highcharts-legend-item > rect")
    text = getElements(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-legend > g > g > .highcharts-legend-item > text")
    combined = []

    for i in 0...colors.length
      combined.push({
          "color" => colors[i].attribute("fill"),
          "text" => text[i].text
      })
    end

    return combined
  end

  def isGraphTitleDisplayed?(nth=1)
    return isElementVisible(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-title")
  end

  def getGraphTitle(nth=1)
    return getTextForElement(:css, "#graph-#{nth.to_s} > div > svg > .highcharts-title")
  end

end