require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"


module Filter
  include DriverUtility

  def getScreenContent()
    return getElement(:css, "form.filter-form").text
  end

  def getFilterIconText()
    return getElement(:css, "button[ng-click='toggleFilterState()']").text
  end

  def getFilterIconAriaLabel()
    return getElement(:css, "button[ng-click='toggleFilterState()']").attribute('aria-label')
  end

  def getFilterButtonLabel()
    return getElement(:css, "button[ng-click='filter()']").text
  end

  def clickOnFilterIcon()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='toggleFilterState()']")
    sleep 0.5
  end

  def clickFilterButton()
    clickJquery("button[ng-click='filter()']")
    sleep 2
  end

  def isFilterCollapsed()
    return is_element_present(:css, "i[class='icon pull-left icon-accordion-static']")
  end

  def isFilterExpanded()
    return is_element_present(:css, "i[class='icon pull-left icon-accordion-active']")
  end

  def getFilterRadioLabels()
    return getElement(:css, "div.row").text
  end

  def getFilterHeader()
    return getElement(:css, "legend.text-left").text
  end

  def isFilterButtonVisible()
    return @driver.find_element(:css, "button[ng-click='filter()']").displayed?
  end

  def getFilterOptionLabelText(nameInCss)
    return getTextForElement(:css, "span[name='" + nameInCss + "']")
  end

  ### RESET FUNCTIONS ###

  def isResetButtonPresent()
    is_element_present(:css, "button[ng-click='reset()']")
  end

  def getResetButtonLabel()
    return getElement(:css, "button[ng-click='reset()']").text
  end

  def clickResetBtn()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='reset()']")
  end

end