require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class EntryForm
  include DriverUtility

  DATE_TEXTFIELD = "input[name='date']"
  TIME_TEXTFIELD = "input[name='time']"
  SURGERY_DATE = "input[name='date']"
  START_DATE = "input[id='startDate']"
  END_DATE = "input[id='endDate']"


  def initialize(driver)
    @driver = driver
  end

  def getScreenContent()
    return getElement(:css, "form[name='entryForm']").text()
  end

  def getFormContent()
    return getElement(:css, "form[name='form']").text()
  end

  def isInputChecked(selector)
    return getElement(:css, selector).attribute("checked") ? true : false
  end

  def isSaveButtonVisible()
    waitForPageToFinishLoading
    return is_element_present(:css, "button[ng-click='confirmSave()']")
  end

  def isDeleteButtonVisible()
    return is_element_present(:css, "button[ng-click='delete()']")
  end

  def isCancelButtonVisible()
    return is_element_present(:css, "button[ng-click='cancel()']")
  end

  def isBackButtonVisible()
    return is_element_present(:css, "button[ng-click='goBack()']") ? true : false
  end

  def isBackButtonOnMyStoryScreensVisible()
    return is_element_present(:css, "button[title='Navigation Screen']") ? true : false
  end

  def getBackButtonAltText()
    return getElement(:css, "button[ng-click='goBack()']").attribute("title")
  end

  def clickBackButton()
    waitForPageToFinishLoading
    click(:css, 'button[ng-click="goBack()"]')
    sleep 1
  end

  def clickBackButtonOnMyStoryScreens()
    click(:css, "button[title='Navigation Screen']")
    sleep 1
  end

  def clickSaveButtonBloodPressureAndPulse()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='confirmSave()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickSaveButtonJump()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='confirmSave()']\")[0].scrollIntoView(true)")
    click(:css, "button[ng-click='confirmSave()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def clickSaveButton()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickSaveButtonGoals()
    click(:css, "button[ng-click='confirmSave()']")
    sleep 2.5
  end

  def clickConfirmSave()
    click(:css, "button[ng-click='confirmSave()']")
    sleep 2.5
  end

  def clickDeleteButton
    clickJquery("button[ng-click='delete()']")
    waitForPageToFinishLoading
  end

  def clickCancelButtonJump()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='cancel()']\")[0].scrollIntoView(true)")
    click(:css, "button[ng-click='cancel()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def clickCancelButton()
    clickJquery("button[ng-click='cancel()']")
    sleep 2
    waitForPageToFinishLoading
  end

  def clickAddEntryButton()
    waitForPageToFinishLoading
    click(:css, 'button[ng-click="getDetails()"]')
    waitForPageToFinishLoading
  end

  def clickApplyButton()
    click(:css, 'button[ng-click="filter()"]')
    waitForPageToFinishLoading
  end

  def clickResetButton()
    waitForPageToFinishLoading
    click(:css, 'button[ng-click="reset()"]')
    sleep 1
  end

  def enterDate(text)
    waitForPageToFinishLoading
    sleep 1
    @driver.find_element(:css, DATE_TEXTFIELD).clear()
    setInput(DATE_TEXTFIELD,text)
  end

  def setDateOfSurgeryProcedure(date)
    @driver.find_element(:css, SURGERY_DATE).clear()
    @driver.find_element(:css, SURGERY_DATE).send_keys(date)
  end

  def setStartDate(date)
    @driver.find_element(:css, START_DATE).clear
    @driver.find_element(:css, START_DATE).send_keys(date)
  end

  def setEndDate(date)
    @driver.find_element(:css, END_DATE).clear
    @driver.find_element(:css, END_DATE).send_keys(date)
  end

end